#ifndef	   UNIVERSAL_NAME_H_INCLUDED
#define	   UNIVERSAL_NAME_H_INCLUDED

// Author:		H. Shimora
// Created:		Jun  2 2009
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Jun  2 2009    base version.
//
//

#include <string>

class Universal_Name
{
private:
    std::string	namespace_uri;
    std::string	local_name;

public:
    Universal_Name( const Universal_Name & uname )
        : namespace_uri( uname.namespace_uri ),
          local_name( uname.local_name )
    {
    }

    Universal_Name( const std::string & namespace_uri,
                    const std::string & local_name )
        : namespace_uri( namespace_uri ),
          local_name( local_name )
    {
    }

    Universal_Name( const std::string & name )
        : namespace_uri(),
          local_name()
    {
        if ( name.empty() )
        {
            return;
        }

        if ( *(name.begin()) == '{' )
        {
            std::string::size_type index = name.find_first_of( '}');

            if ( index == std::string::npos )
            {
                return;
            }

            this -> namespace_uri = name.substr( 1, index - 1 );
            this -> local_name = name.substr( index + 1 );
        }
        else
        {
            this -> local_name = name;
        }
    }

    const std::string & getNamespaceURI() const
    {
        return namespace_uri;
    }

    const std::string & getLocalName() const
    {
        return local_name;
    }

    std::string getFQN() const
    {
        return std::string( "{" ) + namespace_uri + "}" + local_name;
    }

    std::string getShortFQN() const
    {
        if ( namespace_uri.empty() )
        {
            return local_name;
        }
        else
        {
            return std::string( "{" ) + namespace_uri + "}" + local_name;
        }
    }

    bool operator== ( const Universal_Name & uname )
    {
        return this -> local_name == uname.local_name
            && this -> namespace_uri == uname.namespace_uri;
    }

    bool operator< ( const Universal_Name & uname ) const
    {
        if ( this -> namespace_uri < uname.namespace_uri )
        {
            return true;
        }

        return (this -> local_name < uname.local_name);
    }
};

#endif	/* UNIVERSAL_NAME_H_INCLUDED */
