#include "fuse_xml.h"
#include <fuse.h>
#include <sys/stat.h> // for umask()
#include <iostream> // for cerr

#include "xml_data_tree.h"


ref_count_ptr<fuse_xml::XMLDataTree> xml_data_tree;


int main( int argc, char * argv[] )
{
    //
    // parse xml tree
    //
    const char * path = static_cast<const char *>(0);

    if ( argc >= 2 )
    {
        path = argv[1];
    }
    else
    {
        std::cerr << "Usage: " << argv[0] << " FILE.xml FUSE_OPTIONS"
                  << std::endl;

        return EXIT_FAILURE;
    }

    if ( (xml_data_tree = fuse_xml::XMLDataTree::parse( path )).null() )
    {
        return EXIT_FAILURE;
    }

    //
    // create fuse file system
    //
    ::umask( 0x0 );

    struct fuse_operations operations = fuse_xml::FuseXML::getFuseOperations();

    return fuse_main( argc - 1, argv + 1, &operations, NULL );
}
