#ifndef	   UDP_PSEUDO_CONNECTION_H_INCLUDED
#define	   UDP_PSEUDO_CONNECTION_H_INCLUDED

// Author:		H. Shimora
// Created:		Apr  6 2000
// Last-Modified:	Apr  6 2000
// Version:		0.10

//------------------------------------------------
// Change Log:
//------------------------------------------------
// version 0.10  Apr  6 2000
//
//


#ifdef HAVE_CONFIG_H
# include  "config.h"
#endif

#include  "ip_address.h"
#include  "time_stamp.h"
#include  "ref_count_ptr.h"
#include  "ref_count_array_ptr.h"
#include  "posix_compat_socket_headers.h"
#include  <string>

class  UDP_Pseudo_Connection
{
protected:
	SOCKET_FD_TYTE		sfd;
	struct sockaddr_in	addr;

	Time_Stamp		recv_time;
	bool			received;

	size_t			buffer_size;

	long			max_response;

	bool			debug_flag;

public:
	UDP_Pseudo_Connection( const std::string &  host ,
			       port_number_t  port_num ,
			       bool  debug ,
			       size_t  buf_size ,
			       long  max_resp ,
			       bool  close_on_exec );

	UDP_Pseudo_Connection( port_number_t  port_num ,
			       bool  debug ,
			       size_t  buf_size ,
			       long  max_resp ,
			       bool  close_on_exec );

	~UDP_Pseudo_Connection();

	operator bool() const;
	bool	responsive() const;

	long	get_max_response() const;
	void	set_max_response( long  max_resp );

	int	setsockopt( int  level ,
			    int  option ,  const void *  option_value ,
			    socklen_t  option_length );

	int	send( const std::string &  str );

	int	recv( ref_count_ptr<std::string> *  buf ,
		      bool  block ,  bool  reply = false );

	int	recv( ref_count_ptr<std::string> *  buf ,
		      long  usec ,  bool  reply = false );

	int	recv( std::string *  buf ,
		      bool  block ,  bool  reply = false );

	int	recv( std::string *  buf ,
		      long  usec ,  bool  reply = false );

	int	recv( ref_count_array_ptr<char> *  buf ,  bool  append_nul ,
		      bool  block , bool  reply = false );

	int	recv( ref_count_array_ptr<char> *  buf ,  bool  append_nul ,
		      long  usec ,  bool  reply = false );

	int	recv( char *  buf ,  size_t  len ,  bool  append_nul ,
		      long  usec ,  bool  reply = false );

	int	recv( char *  buf ,  size_t  len ,  bool  append_nul ,
		      bool  block ,  bool  reply = false );

	SOCKET_FD_TYTE	fd() const;

	int	close();
};


#endif	/* UDP_PSEUDO_CONNECTION_H_INCLUDED */
