#include  "stream_socket_wrapper.h"
#include  <cstdio>

#include  <sys/types.h>
#ifdef HAVE_CONFIG_H
#  include  "config.h"

#  ifdef HAVE_UNISTD_H
#    include  <unistd.h>
#  endif
#else
#  include  <unistd.h>
#endif

using namespace std;


Stream_Socket_Wrapper::Stream_Socket_Wrapper
			      ( const ref_count_ptr<Stream_Socket> &  sock )
	: sock( sock ) ,
	  have_newline( false ) ,
	  line(),
	  buffer_from( 0 ),
	  buffer_to( 0 )
{
}

void   Stream_Socket_Wrapper::handle
			      ( const ref_count_ptr<Stream_Socket> &  sock )
{
	this -> sock = sock;
}

Stream_Socket_Wrapper::operator bool () const
{
	return( this -> valid() );
}

bool    Stream_Socket_Wrapper::valid() const
{
	if ( this -> sock )
	{
		return( this -> sock -> valid() );
	}
	else
	{
		return( false );
	}
}

ref_count_ptr<Stream_Socket>  Stream_Socket_Wrapper::socket() const
{
	return( this -> sock );
}

int    Stream_Socket_Wrapper::fd() const
{
	if ( this -> sock )
	{
		return( this -> sock -> fd() );
	}
	else
	{
		return( -1 );
	}
}

bool   Stream_Socket_Wrapper::poll() const
{
	if ( this -> sock )
	{
		return( this -> sock -> poll() );
	}
	else
	{
		return( -1 );
	}
}

void   Stream_Socket_Wrapper::close()
{
	if ( this -> sock )
	{
		this -> sock -> close();
	}
}

int    Stream_Socket_Wrapper::set_close_on_exec()
{
	if ( this -> sock )
	{
		return( this -> sock -> set_close_on_exec() );
	}
	else
	{
		return( -1 );
	}
}

bool   Stream_Socket_Wrapper::connected() const
{
	if ( this -> sock )
	{
		return( this -> sock -> connected() );
	}
	else
	{
		return( false );
	}
}

bool   Stream_Socket_Wrapper::input_eof() const
{
	if ( this -> sock )
	{
		return( this -> sock -> input_eof() );
	}
	else
	{
		return( true );
	}
}

bool   Stream_Socket_Wrapper::output_eof() const
{
	if ( this -> sock )
	{
		return( this -> sock -> output_eof() );
	}
	else
	{
		return( true );
	}
}


bool   Stream_Socket_Wrapper::line_completed() const
{
	while( const_cast<Stream_Socket_Wrapper *>(this)
	       -> internal_read_char( false ) )
	{
	}

	return( this -> have_newline );
}

std::string  Stream_Socket_Wrapper::get_line()
{
	std::string	ret = line;
	line = "";
	have_newline = false;

	while( ret.size() > 0
	    && ( *(ret.rbegin()) == '\n'
	      || *(ret.rbegin()) == '\r' ) )
	{
		ret.erase( ret.size() - 1 );
	}

	return( ret );
}

// private
bool   Stream_Socket_Wrapper::internal_read_char( bool  block )
{
	if ( this -> have_newline
	     || ! this -> valid()
	     || this -> input_eof() )
	{
		return( false );
	}

	if ( this -> buffer_to > this -> buffer_from )
	{
		char ch = this -> buffer[this -> buffer_from];
		this -> buffer_from ++;

		this -> line += ch;

		if ( ch == '\n' )
		{
			this -> have_newline = true;
		}

		return true;
	}

	if ( block || this -> sock -> poll() )
	{
		this -> buffer_from = 0;
		this -> buffer_to = 0;

		ssize_t n = this -> sock -> recv( this -> buffer ,
						  sizeof(this -> buffer) ,
						  0 );
		switch( n )
		{
		case -1:
			std::perror( "recv" );
			break;

		case 0:
			this -> close();
			break;

		default:
			{
				char ch = this -> buffer[0];

				this -> line += ch;
				this -> buffer_from = 1;
				this -> buffer_to = n;

				if ( ch == '\n' )
				{
				    this -> have_newline = true;
				}

				return( true );
			}
			break;
		}
	}

	return( false );
}

void   Stream_Socket_Wrapper::recv_message( std::string *  mes )
{
	while( ! this -> have_newline
	       && this -> internal_read_char( true )
	       && this -> valid()
	       && ! this -> input_eof() )
	{
	}

	*mes = this -> get_line();
}

void   Stream_Socket_Wrapper::send_message( const std::string &  mes ) const
{
	if ( sock && sock -> valid() )
	{
		this -> sock -> write_all( mes.c_str() , mes.length() );
	}
}
