#ifndef	   PRIMITIVE_TYPE_WRAPPER_H_INCLUDED
#define	   PRIMITIVE_TYPE_WRAPPER_H_INCLUDED

// Author:		H. Shimora
// Created:		Dec 21 2001
// Version:		0.00

//------------------------------------------------
// Change Log:
//------------------------------------------------
// version 0.00  Dec 21 2001    base version.
//
//

#include  <cmath>

class  Double
{
private:
	double	value;

public:
	Double( double  x ) : value( x ) {}

	operator double () const
	{
		return( value );
	}

	void	operator += ( double  x )
	{
		value += x;
	}

	void	operator -= ( double  x )
	{
		value -= x;
	}

	void	operator *= ( double  x )
	{
		value *= x;
	}

	void	operator /= ( double  x )
	{
		value /= x;
	}

	int	sign() const
	{
		if ( value > 0.0 )
		{
			return( + 1 );
		}
		else if ( value < 0.0 )
		{
			return( - 1 );
		}
		else
		{
			return( 0 );
		}
	}

	double	abs() const
	{
		return( std::fabs( value ) );
	}
};


#endif	/* PRIMITIVE_TYPE_WRAPPER_H_INCLUDED */
