#include  "test_environment.h"

#include  "fdstream.h"
#include  <iostream>
#include  <unistd.h>
#include  <fcntl.h>

static	const char *	TEST_FILE = "test-file";


int    main( void )
{
	Test_Environment	t;

	int	fd;

	{
		if ( (fd = ::open( TEST_FILE , O_WRONLY | O_CREAT , 0644 ))
		     == -1 )
		{
			std::perror( "open" );

			return( 1 );
		}


		ofdstream	ofd( fd , true /* auto close */ );

		ofd << "hello" << std::endl;
	}


	{
		if ( (fd = ::open( TEST_FILE , O_RDONLY )) == -1 )
		{
			std::perror( "open" );

			return( 1 );
		}


		ifdstream	ifd( fd , true /* auto close */ );

		std::string	line;
		std::getline( ifd , line );

		t.Assert_Equals( "hello" , line );
	}


	return( t.exit_status() );
}
