#include  "d2_vector.h"
#include  <iostream>

static const long	N = 10 * 1000 * 1000;

int    main( void )
{
	D2_Vector	x( 1.0 , 2.0 );
	D2_Vector	y( 0.2 , 0.1 );
	D2_Vector	base( 0.5 , 0.8 );
	D2_Vector	sum;

	for ( long  i = 0  ;  i <= N ;  i ++ )
	{
		D2_Vector	diff_x = x - base;
		D2_Vector	diff_y = y - base;

#if 1
		D2_Vector	n = diff_y
				    .rotate( - diff_x.theta() )
				    .normalize_theta();

		n = n.normalize();
#else
		D2_Vector	n( diff_y.y() , diff_x.x() );
#endif

		sum += n;
		x += sum * static_cast<FLOAT>(1.0e-10);
	}

	std::cout << "sum = [" << sum << "]" << std::endl;

	return( 0 );
}
