#include  "base64_encoder.h"
#include  "base64_table.h"

void   Base64_Encoder::encode( std::string *  buffer ,
			       const std::string &  src )
{
	if ( buffer == static_cast<std::string *>(0) )
	{
		return;
	}

	buffer -> erase();

	struct  Internal_Func
	{
		static	char	get_output_char_0( unsigned char  input_0 )
		{
			return( Base64_Table::table[ (input_0 >> 2) ] );
		}

		static	char	get_output_char_1( unsigned char  input_0 ,
						   unsigned char  input_1 )
		{
			return( Base64_Table::table
				[ (((input_0 & 0x03) << 4)
				   | (input_1 >> 4)) ] );
		}

		static	char	get_output_char_2( unsigned char  input_1 ,
						   unsigned char  input_2 )
		{
			return( Base64_Table::table
				[ (((input_1 & 0x0f) << 2)
				   | (input_2 >> 6)) ] );
		}

		static	char	get_output_char_3( unsigned char  input_2 )
		{
			return( Base64_Table::table
				[ (input_2 & 0x3f) ] );
		}
	};


	for ( size_t  i = 0  ;  i + 2 < src.length()  ;  i += 3 )
	{
		unsigned char	ch_0 = static_cast<char>( src[i + 0] );
		unsigned char	ch_1 = static_cast<char>( src[i + 1] );
		unsigned char	ch_2 = static_cast<char>( src[i + 2] );

		(*buffer) += Internal_Func::get_output_char_0( ch_0 );
		(*buffer) += Internal_Func::get_output_char_1( ch_0 , ch_1 );
		(*buffer) += Internal_Func::get_output_char_2( ch_1 , ch_2 );
		(*buffer) += Internal_Func::get_output_char_3( ch_2 );
	}


	size_t	offset = (src.length() / 3) * 3;
	switch( src.length() % 3 )
	{
	case 0:
	default:
		/* no operation */
		break;

	case 1:
	      {
			unsigned char	ch_0 = static_cast<char>
						( src[offset + 0] );
			unsigned char	ch_1 = 0;

			(*buffer) += Internal_Func::get_output_char_0( ch_0 );
			(*buffer) += Internal_Func::get_output_char_1
					( ch_0 , ch_1 );
			(*buffer) += Base64_Table::padding;
			(*buffer) += Base64_Table::padding;
			break;
	      }

	case 2:
	      {
			unsigned char	ch_0 = static_cast<char>
						( src[offset + 0] );
			unsigned char	ch_1 = static_cast<char>
						( src[offset + 1] );
			unsigned char	ch_2 = 0;

			(*buffer) += Internal_Func
					::get_output_char_0( ch_0 );
			(*buffer) += Internal_Func
					::get_output_char_1( ch_0 , ch_1 );
			(*buffer) += Internal_Func
					::get_output_char_2( ch_1 , ch_2 );
			(*buffer) += Base64_Table::padding;
			break;
	      }

	case 3:
	      {
			unsigned char	ch_0 = static_cast<char>
						( src[offset + 0] );
			unsigned char	ch_1 = static_cast<char>
						( src[offset + 1] );
			unsigned char	ch_2 = static_cast<char>
						( src[offset + 2] );

			(*buffer) += Internal_Func
					::get_output_char_0( ch_0 );
			(*buffer) += Internal_Func
					::get_output_char_1( ch_0 , ch_1 );
			(*buffer) += Internal_Func
					::get_output_char_2( ch_1 , ch_2 );
			(*buffer) += Internal_Func
					::get_output_char_3( ch_2 );
			break;
	      }
	}
}
