/***
 *** Title: Set of XMLSchema 
 *** Author: Itsuki Noda
 *** Date: 2006.09.05
 ***/

package daruma.storage_manager.schema;

import daruma.xml.util.DOMDocumentFactory;
import daruma.xml.util.XMLFormatConverter;
import daruma.xml.NameSpace;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.Attr;
import org.apache.xpath.XPathAPI;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import java.util.ArrayList;
import java.util.List;
import java.io.StringReader;

import daruma.util.Itk;

//======================================================================
/**
 * XML Schema ν򰷤饹
 * StorageManager::getSchema() ʤɤǻ
 */

public class XMLSchemaSet {

    //==================================================
    /**
     * Schema ΣĤΥȥ
     */
    public static class Entry {

	//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
	private String id ; 		///  id
	private String targetNameSpace ; /// ޤΥåNS
	private String string ; 	/// ʸ
	private Element element ;	/// XML
	private List<String> importList ; /// import ǡ

	//------------------------------
	/**
	 * 󥹥ȥ饯
	 */
	public Entry(String string) {
	    this.id = null ;
	    this.string = null ;
	    this.element = null ;
	    this.importList = new ArrayList<String>() ;

	    set(string, true) ;
	}

	//------------------------------
	/**
	 * ʸ
	 * scanp  true ξ硢string  scan 
	 */
	public Entry set(String string, boolean scanp) {

	    this.setString(string) ;

	    if(scanp) {
		scanString() ;
	    }
	    return this ;
	}

	public Entry set(String string) {
	    return set(string, true) ;
	}

	//------------------------------
	/**
	 * string  scan
	 */
	public Entry scanString() {
	    try{
		// Schema  Element 
		Document doc = DOMDocumentFactory.create() ;
		XMLFormatConverter.readNode(new StringReader(this.string), 
					    doc) ;
		this.element = doc.getDocumentElement() ;

		// ID
		setIDTargetNSByElement() ;

		// import å
		checkImport() ;

		return this ;
	    } 
	    catch(ParserConfigurationException ex) {
		ex.printStackTrace() ;
		/* !!! [06/09/06 03:21 I.Noda] !!! 
		 * !!! FIXME: should throw something
		 */
		return null ;
	    } 
	    catch(TransformerException ex) {
		ex.printStackTrace() ;
		/* !!! [06/09/06 03:21 I.Noda] !!! 
		 * !!! FIXME: should throw something
		 */
		return null ;
	    }
	}

	//------------------------------
	/**
	 * Schema Element  IDTargetNS 
	 * ֤ͤ ID
	 */
	public String setIDTargetNSByElement() {
	    try {
		Attr idAttr = 
		    (Attr)XPathAPI.selectSingleNode(this.element, 
						    "@misp:id",
						    NameSpace.DefaultContext) ;
		if(idAttr != null) {
		    this.setID(idAttr.getValue()) ;
		}

		Attr nsAttr =
		    (Attr)XPathAPI.selectSingleNode(this.element, 
						    "@targetNamespace",
						    NameSpace.DefaultContext) ;
		if(nsAttr != null) {
		    this.setTargetNameSpace(nsAttr.getValue()) ;
		}
		
		return getID() ;
	    } 
	    catch(TransformerException ex) {
		ex.printStackTrace() ;
		/* !!! [06/09/06 03:21 I.Noda] !!! 
		 * !!! FIXME: should throw something
		 */
		return null ;
	    }

	}
		
	//------------------------------
	/**
	 * import 
	 */
	public void checkImport() throws TransformerException {
	    NodeIterator nodes = 
		XPathAPI.selectNodeIterator(this.element,
					    "//xsd:import/@namespace",
					    NameSpace.DefaultContext) ;

	    Node node = null ;
	    while((node = nodes.nextNode()) != null) {
		String nsURI = ((Attr)node).getValue() ;
		this.importList.add(nsURI) ;
	    }
					
	}

	//------------------------------
	/**
	 * importList 
	 */
	public List<String> getImportList() {
	    return this.importList ;
	}

	//------------------------------
	/**
	 * id 
	 */
	public String getID() {
	    return this.id ;
	}

	//------------------------------
	/**
	 * id 
	 */
	public String setID(String id) {
	    return this.id = id ;
	}

	//------------------------------
	/**
	 * id 
	 */
	public String getTargetNameSpace() {
	    return this.targetNameSpace ;
	}

	//------------------------------
	/**
	 * id 
	 */
	public String setTargetNameSpace(String nsURI) {
	    return this.targetNameSpace = nsURI ;
	}

	//------------------------------
	/**
	 * schema ʸ
	 */
	public String getString() {
	    try {
		if(this.string == null && this.element != null) {
		    this.string = 
			XMLFormatConverter.toString(this.element, false) ;
		}
		return this.string ;
	    } catch(TransformerException ex) {
		ex.printStackTrace() ;
		/* !!! [06/09/06 03:21 I.Noda] !!! 
		 * !!! FIXME: should throw something
		 */
		return null ;
	    }
	}

	//------------------------------
	/**
	 * schema ʸ򥻥å
	 */
	public String setString(String string) {
	    return this.string = string ;
	}
    }

    //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    private List<Entry> list ;
    
    //--------------------------------------------------
    /**
     * constructor
     */
    public XMLSchemaSet() {
	this.list = new ArrayList<Entry>() ;
    }
    
    //--------------------------------------------------
    /**
     * add
     * return: Ͽ entry ⤷¸ǤСnull ֤
     */
    public Entry add(String schemaStr) {
	Entry entry = new Entry(schemaStr) ;
	Entry oldEntry = getEntryByID(entry.getID()) ;
	if(oldEntry == null) {
	    this.list.add(entry) ;
	    return entry ;
	} else {
	    return null ;
	}
    }

    //--------------------------------------------------
    /**
     * ID ˤ Entry ʤ null 
     */
    public Entry getEntryByID(String uri) {
	for(Entry entry : this.list) {
	    if(entry.getID().equals(uri)) {
		return entry ;
	    }
	}
	return null ;
    }

    //--------------------------------------------------
    /**
     * list 
     */
    public List<Entry> getList() {
	return this.list ;
    } 

    //--------------------------------------------------
    /**
     * entry  
     */
    public long size() {
	return this.list.size() ;
    } 
    
}
