package daruma.sql;

import daruma.sql.DatabaseConnectionFactory;
import daruma.sql.MySQLDatabaseConnection;

public class MySQLDatabaseConnectionFactory extends DatabaseConnectionFactory
{
    private String mysqlHost;
    private int mysqlPort;


    public MySQLDatabaseConnectionFactory( String mysqlHost, int mysqlPort )
	throws DatabaseConnectionException
    {
	this.mysqlHost = mysqlHost;
	this.mysqlPort = mysqlPort;

	super.loadClass();
    }


    @Override
    public String getDriverClass()
    {
	return "com.mysql.jdbc.Driver";
    }


    @Override
    public DatabaseConnection create()
    {
	return new MySQLDatabaseConnection( this.mysqlHost, this.mysqlPort );
    }
}
