/*
 * Decompiled with CFR 0.152.
 */
package daruma.xml.util;

import daruma.util.Pair;
import daruma.xml.handler.XSAXDOMCreateHandler;
import daruma.xml.util.DOMDocumentFactory;
import daruma.xml.util.EndOfDocumentException;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLFormatConverter {
    private XMLFormatConverter() {
    }

    public static void print(Node node, OutputStream out) throws TransformerException {
        XMLFormatConverter.print(node, out, true);
    }

    public static void print(Node node, OutputStream out, boolean withDocDeclP) throws TransformerException {
        XMLFormatConverter.convert((Source)new DOMSource(node), out, withDocDeclP);
    }

    public static void print(Node node, OutputStream out, boolean withDocDeclP, String encoding) throws TransformerException, UnsupportedEncodingException {
        XMLFormatConverter.convert((Source)new DOMSource(node), (Writer)new BufferedWriter(new OutputStreamWriter(out, encoding)), withDocDeclP);
    }

    public static void convert(Source source, OutputStream out, boolean withDocDeclP) throws TransformerException {
        XMLFormatConverter.convert(source, (Writer)new PrintWriter(out), withDocDeclP);
        try {
            out.flush();
        }
        catch (IOException e) {
            throw new TransformerException(e);
        }
    }

    public static void convert(Reader in, Writer out, boolean withDocDeclP) throws TransformerException {
        XMLFormatConverter.convert((Source)new StreamSource(in), out, withDocDeclP);
        try {
            out.flush();
        }
        catch (IOException e) {
            throw new TransformerException(e);
        }
    }

    public static void convert(Source source, Writer out, boolean withDocDeclP) throws TransformerException {
        XMLFormatConverter.convert(source, new StreamResult(out), withDocDeclP);
        try {
            out.flush();
        }
        catch (IOException e) {
            throw new TransformerException(e);
        }
    }

    public static void convert(Source source, Result result, boolean withDocDeclP) throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        if (!withDocDeclP) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        transformer.transform(source, result);
    }

    public static void printElement(Node element, OutputStream out) throws TransformerException {
        XMLFormatConverter.convert((Source)new DOMSource(element), out, false);
    }

    public static void obsolute_printElement(Node element, OutputStream out) throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        DOMSource source = new DOMSource(element);
        StreamResult result = new StreamResult(new PrintWriter(out));
        transformer.transform(source, result);
        try {
            out.flush();
        }
        catch (IOException e) {}
    }

    public static void printTextWithoutXMLDeclaration(Reader in, Writer out) throws TransformerException {
        XMLFormatConverter.convert(in, out, false);
    }

    public static void obsolute_printTextWithoutXMLDeclaration(Reader in, Writer out) throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StreamSource source = new StreamSource(in);
        StreamResult result = new StreamResult(out);
        transformer.transform(source, result);
        try {
            out.flush();
        }
        catch (IOException e) {}
    }

    public static void readNode(Source in, Node node) throws TransformerException {
        XMLFormatConverter.convert(in, new DOMResult(node), false);
    }

    public static void obsolute_readNode(Source in, Node node) throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        Source source = in;
        DOMResult result = new DOMResult(node);
        transformer.transform(source, result);
    }

    public static void readNode(InputStream in, Node node) throws TransformerException {
        XMLFormatConverter.readNode(new StreamSource(in), node);
    }

    public static void readNode(Reader in, Node node) throws TransformerException {
        XMLFormatConverter.readNode(new StreamSource(in), node);
    }

    public static String toString(Node node) throws TransformerException {
        return XMLFormatConverter.toString(node, true);
    }

    public static String toString(Node node, boolean withDocDeclP) throws TransformerException {
        ByteArrayOutputStream ostrm = new ByteArrayOutputStream();
        XMLFormatConverter.print(node, ostrm, withDocDeclP);
        return ostrm.toString();
    }

    public static Element stringToDOMElement(String str) throws TransformerException {
        return XMLFormatConverter.stringToDOMElement(str, null);
    }

    public static Element stringToDOMElement(String str, Document doc) throws TransformerException {
        return XMLFormatConverter.streamToDOMElement(new StringReader(str), doc);
    }

    public static Element streamToDOMElement(InputStream in) throws TransformerException {
        Document doc;
        try {
            doc = DOMDocumentFactory.create();
        }
        catch (ParserConfigurationException e) {
            throw new TransformerException(e);
        }
        return XMLFormatConverter.streamToDOMElement(in, doc);
    }

    public static Document streamToDOMDocument(InputStream in) throws TransformerException {
        XSAXDOMCreateHandler h;
        XMLReader parser;
        SAXParserFactory f = SAXParserFactory.newInstance();
        f.setNamespaceAware(true);
        try {
            parser = f.newSAXParser().getXMLReader();
            h = new XSAXDOMCreateHandler(new ByteArrayOutputStream(), parser, true);
            parser.setContentHandler(h);
            parser.setErrorHandler(h);
        }
        catch (ParserConfigurationException e) {
            throw new TransformerException("Can't create SAX parser", e);
        }
        catch (SAXException e) {
            throw new TransformerException("Can't create SAX parser", e);
        }
        try {
            try {
                parser.parse(new InputSource(in));
            }
            catch (EndOfDocumentException e) {}
        }
        catch (SAXParseException e) {
            throw new TransformerException(e);
        }
        catch (SAXException e) {
            throw new TransformerException(e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new TransformerException(e);
        }
        return h.getDOMDocument();
    }

    public static Element streamToDOMElement(InputStream in, Document doc) throws TransformerException {
        XSAXDOMCreateHandler h;
        XMLReader parser;
        SAXParserFactory f = SAXParserFactory.newInstance();
        f.setNamespaceAware(true);
        try {
            parser = f.newSAXParser().getXMLReader();
            h = new XSAXDOMCreateHandler(new ByteArrayOutputStream(), parser, true, doc);
            parser.setContentHandler(h);
            parser.setErrorHandler(h);
        }
        catch (ParserConfigurationException e) {
            throw new TransformerException("Can't create SAX parser", e);
        }
        catch (SAXException e) {
            throw new TransformerException("Can't create SAX parser", e);
        }
        try {
            try {
                parser.parse(new InputSource(in));
            }
            catch (EndOfDocumentException e) {}
        }
        catch (SAXParseException e) {
            throw new TransformerException(e);
        }
        catch (SAXException e) {
            throw new TransformerException(e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new TransformerException(e);
        }
        return h.getDocumentElement();
    }

    public static Element streamToDOMElement(Reader reader, Document doc) throws TransformerException {
        XSAXDOMCreateHandler h;
        XMLReader parser;
        SAXParserFactory f = SAXParserFactory.newInstance();
        f.setNamespaceAware(true);
        try {
            parser = f.newSAXParser().getXMLReader();
            h = new XSAXDOMCreateHandler(new ByteArrayOutputStream(), parser, true, doc);
            parser.setContentHandler(h);
            parser.setErrorHandler(h);
        }
        catch (ParserConfigurationException e) {
            throw new TransformerException("Can't create SAX parser", e);
        }
        catch (SAXException e) {
            throw new TransformerException("Can't create SAX parser", e);
        }
        try {
            try {
                parser.parse(new InputSource(reader));
            }
            catch (EndOfDocumentException e) {}
        }
        catch (SAXParseException e) {
            throw new TransformerException(e);
        }
        catch (SAXException e) {
            throw new TransformerException(e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new TransformerException(e);
        }
        return h.getDocumentElement();
    }

    public static Element stringToElement(String str, Document doc) throws TransformerException {
        return XMLFormatConverter.stringToDOMElement(str, doc);
    }

    public static Pair<String, String> splitToHeaderTailerStrBy(Node node, String separator, boolean withDocDeclP) throws TransformerException {
        String nodeStr = XMLFormatConverter.toString(node, withDocDeclP);
        int sepIndex = nodeStr.indexOf(separator);
        String header = null;
        String tailer = null;
        if (sepIndex < 0) {
            header = nodeStr;
            tailer = null;
        } else {
            int sepLength = separator.length();
            header = nodeStr.substring(0, sepIndex);
            tailer = nodeStr.substring(sepIndex + sepLength);
        }
        return new Pair<String, Object>(header, tailer);
    }
}

