/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.operation.IsSimpleOp;

public class MultiLineString
extends GeometryCollection {
    private static final long serialVersionUID = 8166665132445433741L;

    public MultiLineString(LineString[] lineStrings, PrecisionModel precisionModel, int SRID) {
        super(lineStrings, new GeometryFactory(precisionModel, SRID));
    }

    public MultiLineString(LineString[] lineStrings, GeometryFactory factory) {
        super(lineStrings, factory);
    }

    public int getDimension() {
        return 1;
    }

    public int getBoundaryDimension() {
        if (this.isClosed()) {
            return -1;
        }
        return 0;
    }

    public String getGeometryType() {
        return "MultiLineString";
    }

    public boolean isClosed() {
        if (this.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.geometries.length; ++i) {
            if (((LineString)this.geometries[i]).isClosed()) continue;
            return false;
        }
        return true;
    }

    public boolean isSimple() {
        return new IsSimpleOp().isSimple(this);
    }

    public Geometry getBoundary() {
        if (this.isEmpty()) {
            return this.getFactory().createGeometryCollection(null);
        }
        GeometryGraph g = new GeometryGraph(0, this);
        Coordinate[] pts = g.getBoundaryPoints();
        return this.getFactory().createMultiPoint(pts);
    }

    public MultiLineString reverse() {
        int nLines = this.geometries.length;
        LineString[] revLines = new LineString[nLines];
        for (int i = 0; i < this.geometries.length; ++i) {
            revLines[nLines - 1 - i] = ((LineString)this.geometries[i]).reverse();
        }
        return this.getFactory().createMultiLineString(revLines);
    }

    public boolean equalsExact(Geometry other, double tolerance) {
        if (!this.isEquivalentClass(other)) {
            return false;
        }
        return super.equalsExact(other, tolerance);
    }
}

