#include  "sockctl_option_analyzer.h"
#include  "stream_combinator.h"
#include  "socket_io.h"
#include  "combination_io.h"
#include  "fd_io.h"
#include  "file_io.h"
#include  "comstream.h"
#if defined(ADD_BINARY_SIZE_HEADER)
# include  "line_buffer_binary_size_wrapper_output.h"
#endif
#include  "posix_compat_socket_headers.h"
#include  "posix_compat_signal.h" // for signal()
#include  <fcntl.h>		  // for open()
#include  <cstdio>		  // for perror()
#include  <exception>
#include  <iostream>

#ifndef DEFAULT_PORT
# define DEFAULT_PORT 0
#endif


int    main( int  argc ,  char *  argv[] )
{
  int	return_value = EXIT_SUCCESS;
  try
  {
	//
	// option analysis
	//
	Sockctl_Option_Analyzer	opt( "127.0.0.1" /* IPv4 localhost */ ,
				     DEFAULT_PORT );

	if ( ! opt.analyze( argc , argv ) )
	{
		opt.usage();
		return( EXIT_SUCCESS );
	}
	else if ( opt.help() )
	{
		opt.usage();
		return( EXIT_FAILURE );
	}


	//
	// signal handling
	//
#ifdef HAVE_PIPE
	if ( std::signal( SIGPIPE , SIG_IGN ) == SIG_ERR )
	{
		std::perror( "signal" );

		return( EXIT_FAILURE );
	}
#endif


	//
	// initialize socket environment
	//
	{
	    std::string	error_message;
	    if ( ! Socket_System_Environment::initialize( &error_message ) )
	    {
		std::cerr << error_message << std::endl;

		return( EXIT_FAILURE );
	    }
	}


	if ( opt.rest_options().empty() )
	{
#if defined(ADD_BINARY_SIZE_HEADER)
		ref_count_ptr<Abstract_IO>	s;
		s = new Socket_IO( opt.host() , opt.port() , opt.ipv4_only() );

		Stream_Combinator
		    comb( new Combination_IO
			  ( s ,
			    new Line_Buffer_Binary_Size_Wrapper_Output( s ) ) ,
			  new Combination_IO
			  ( new FD_IO( STDIN_FILENO  ) ,
			    new FD_IO( STDOUT_FILENO ) ) ,
			  opt.debug() ,
			  opt.print_io() );
#else
		Stream_Combinator
		    comb( new Socket_IO( opt.host() , opt.port() ,
					 opt.ipv4_only() ) ,
			  new Combination_IO
			  ( new FD_IO( STDIN_FILENO  ) ,
			    new FD_IO( STDOUT_FILENO ) ) ,
			  opt.debug() ,
			  opt.print_io() );
#endif

		if ( ! comb.valid() )
		{
			return EXIT_FAILURE;
		}

		comb.run();
	}
	else
	{
		for ( size_t  i = 0  ;  i < opt.rest_options().size()  ;
		      i ++ )
		{
#if defined(IGNORE_FILE_COMMENT)
			icomstream	com( "grep" ,
					     "^[^#]" ,
					     opt.rest_options()[i].c_str() ,
					     static_cast<char *>(0) );

			Stream_Combinator
			    comb( new Socket_IO
				  ( opt.host() , opt.port() ,
				    opt.ipv4_only() ) ,
				  new Combination_IO
				  ( new FD_IO( com.fd( std::ios::out ) ) ,
				    new FD_IO( STDOUT_FILENO ) ) ,
				  opt.debug() ,
				  opt.print_io() );

#elif defined(ADD_BINARY_SIZE_HEADER)
			ref_count_ptr<Abstract_IO>	s;
			s = new Socket_IO( opt.host() , opt.port() ,
					   opt.ipv4_only() );

			Stream_Combinator
			    comb( new Combination_IO
				  ( s ,
				    new Line_Buffer_Binary_Size_Wrapper_Output( s ) ) ,
				  new Combination_IO
				  ( new File_IO( opt.rest_options()[i] ,
						 /* read  */ true ,
						 /* write */ false ) ,
				    new Line_Buffer_Binary_Size_Wrapper_Output
				    ( new FD_IO( STDOUT_FILENO ) ) ) ,
				  opt.debug() ,
				  opt.print_io() );
#else
			Stream_Combinator
			    comb( new Socket_IO( opt.host() , opt.port() ,
						 opt.ipv4_only() ) ,
				  new Combination_IO
				  ( new File_IO( opt.rest_options()[i] ,
						 /* read  */ true ,
						 /* write */ false ) ,
				    new FD_IO( STDOUT_FILENO ) ) ,
				  opt.debug() ,
				  opt.print_io() );
#endif

			if ( ! comb.valid() )
			{
				return EXIT_FAILURE;
			}

			comb.run();
		}
	}
  }
  catch( const std::exception &  e )
  {
	if ( *(e.what()) != '\0' )
	{
		std::cerr << e.what() << std::endl;
	}

	return_value = EXIT_FAILURE;
  }
  catch(...)
  {
	std::cerr << "exception caught!!" << std::endl;

	return_value = EXIT_FAILURE;
  }

  std::string	error_message;
  if ( ! Socket_System_Environment::finalize( &error_message ) )
  {
	  std::cerr << error_message << std::endl;

	  return_value = EXIT_FAILURE;
  }

  return( return_value );
}
