#ifndef	   POSIX_COMPAT_SOCKET_HEADERS_H_INCLUDED
#define	   POSIX_COMPAT_SOCKET_HEADERS_H_INCLUDED

// Author:		H. Shimora
// Created:		Mar  1 2007
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Mar  1 2007    base version.
//
//

#if defined(HAVE_CONFIG_H)
  #include "config.h"
#else
  #if defined(MINGW)
    #include  "posix_compat_implement_mingw.h"
    typedef SOCKET        SOCKET_FD_TYTE;
    typedef char *        SOCKET_PAYLOAD_TYPE;
    typedef const char *  CONST_SOCKET_PAYLOAD_TYPE;
    typedef char *        SOCKOPT_OPTION_VALUE_POINTER_TYPE;
    typedef const char *  CONST_SOCKOPT_OPTION_VALUE_POINTER_TYPE;
    #define	SOCKET_CLOSE_FUNCTION	(::closesocket)
    static const SOCKET_FD_TYTE  BAD_SOCKET_FD = INVALID_SOCKET;
    static const int  SOCKET_ERROR_CODE = SOCKET_ERROR;
  #else
    extern "C"
    {
	#include  <sys/types.h>
	#include  <sys/socket.h>
	#include  <sys/un.h>
	#include  <netinet/in.h>
	#include  <netdb.h>
    }
    #define  HAVE_SOCKADDR_UN
    typedef int           SOCKET_FD_TYTE;
    typedef void *        SOCKET_PAYLOAD_TYPE;
    typedef void *        SOCKOPT_OPTION_VALUE_POINTER_TYPE;
    typedef const void *  CONST_SOCKOPT_OPTION_VALUE_POINTER_TYPE;
    typedef const void *  CONST_SOCKET_PAYLOAD_TYPE;
    #define	SOCKET_CLOSE_FUNCTION	(::close)
    static const SOCKET_FD_TYTE  BAD_SOCKET_FD = -1;
    static const int  SOCKET_ERROR_CODE = -1;
    #if ! defined(__CYGWIN__)
        #define HAVE_ADDRINFO
    #endif
  #endif
#endif


#ifndef HAVE_SOCKLEN_T
  #if defined(__FreeBSD__)
    #if __FreeBSD__ >= 4
      typedef	socklen_t	SOCKLEN_T;
    #else
      typedef	int		SOCKLEN_T;
    #endif
  #elif defined(__NetBSD__) || defined(__linux) || defined(__APPLE__)
    typedef	socklen_t	SOCKLEN_T;
  #elif defined(MINGW)
    typedef	socklen_t	SOCKLEN_T;
  #else
    typedef	int		SOCKLEN_T;
  #endif
#endif


#if defined(MINGW)
inline
ssize_t  recv( int  fd ,  void *  buf ,  size_t  len ,  int  flags )
{
	return( static_cast<ssize_t>( recv( static_cast<SOCKET>(fd) ,
					    static_cast<char *>(buf) ,
					    static_cast<int>(len) ,
					    flags ) ) );
}

inline
ssize_t  recv( int  fd ,  char *  buf ,  size_t  len ,  int  flags )
{
	return( recv( static_cast<int>(fd) ,
		      static_cast<void *>(buf) ,
		      static_cast<size_t>(len) ,
		      flags ) );
}

inline
ssize_t  send( int  fd ,  const void *  buf ,  size_t  len ,  int  flags )
{
	return( static_cast<ssize_t>( send( static_cast<SOCKET>(fd) ,
					    static_cast<const char *>(buf) ,
					    static_cast<int>(len) ,
					    flags ) ) );
}

inline
ssize_t  send( int  fd ,  const char *  buf ,  size_t  len ,  int  flags )
{
	return( static_cast<ssize_t>( send( static_cast<int>(fd) ,
					    static_cast<const void *>(buf) ,
					    static_cast<size_t>(len) ,
					    flags ) ) );
}
#endif

#include  <string>

class  Socket_System_Environment
{
public:
	static bool initialized;

private:
	Socket_System_Environment();

public:
	static	bool    initialize( std::string *  error_message );
	static	bool    finalize  ( std::string *  error_message );
};


#endif	/* POSIX_COMPAT_SOCKET_HEADERS_H_INCLUDED */
