/*
 * Decompiled with CFR 0.152.
 */
package daruma.server;

import daruma.util.LogWriter;
import java.io.IOException;
import java.net.Socket;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class ConnectionInfoHolder {
    private Object lock = new Object();
    private long currentClientConnectionID = -1L;
    private Map<Long, ConnectionInfo> clientConnectionMap = new TreeMap<Long, ConnectionInfo>();

    public void addClientSocket(Socket s, long connectionID, Date date) {
        this.clientConnectionMap.put(connectionID, new ConnectionInfo(s, connectionID, date));
    }

    private ConnectionInfo getClientInfo(long connectionID) {
        return this.clientConnectionMap.get(connectionID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ConnectionInfo> getClientSocketSet() {
        Object object = this.lock;
        synchronized (object) {
            return new TreeSet<ConnectionInfo>(this.clientConnectionMap.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentClientSocket(long connectionID) {
        Object object = this.lock;
        synchronized (object) {
            ConnectionInfo c = this.getClientInfo(connectionID);
            this.currentClientConnectionID = connectionID;
            c.updateStatus(ConnectionStatus.Running);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket getCurrentClientSocket() {
        Object object = this.lock;
        synchronized (object) {
            return this.getClientInfo(this.currentClientConnectionID).getSocket();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisconnectResult forceDisconnectClient() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentClientConnectionID != -1L) {
                LogWriter.qwrite("INFO", "forced closing client Socket: ", this.getClientInfo(this.currentClientConnectionID).getSocket());
                return this.closeSocket(this.currentClientConnectionID);
            }
            return new DisconnectResult(true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DisconnectResult closeSocket(long connectionID) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            ConnectionInfo c = this.getClientInfo(connectionID);
            if (c == null) {
                return new DisconnectResult(false, false);
            }
            Socket s = c.getSocket();
            try {
                if (connectionID == this.currentClientConnectionID) {
                    this.currentClientConnectionID = -1L;
                }
                s.close();
                DisconnectResult disconnectResult = new DisconnectResult(true, true);
                return disconnectResult;
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                this.clientConnectionMap.remove(connectionID);
            }
        }
    }

    public class DisconnectResult {
        private boolean success;
        private boolean done;

        public DisconnectResult(boolean success, boolean done) {
            this.success = success;
            this.done = done;
        }

        public boolean getSuccess() {
            return this.success;
        }

        public boolean getDone() {
            return this.done;
        }
    }

    public class ConnectionInfo
    implements Comparable<ConnectionInfo> {
        private long connectionID;
        private Socket socket;
        private Date connectedDate;
        private ConnectionStatus status;

        public ConnectionInfo(Socket socket, long connectionID, Date connectedDate) {
            this.connectionID = connectionID;
            this.socket = socket;
            this.connectedDate = connectedDate;
            this.status = ConnectionStatus.Waiting;
        }

        public long getConnectionID() {
            return this.connectionID;
        }

        public Socket getSocket() {
            return this.socket;
        }

        public Date getConnectedDate() {
            return this.connectedDate;
        }

        public ConnectionStatus getStatus() {
            return this.status;
        }

        private void updateStatus(ConnectionStatus status) {
            this.status = status;
        }

        @Override
        public int compareTo(ConnectionInfo c) {
            return (int)(this.connectionID - c.connectionID);
        }
    }

    public static enum ConnectionStatus {
        Waiting,
        Running;

    }
}

