package daruma.wfs.filter.predicates;

import daruma.wfs.filter.PredicateDescription;
import daruma.wfs.filter.PropertyPathConverter;

import daruma.xml.util.ElementUtil;
import daruma.xml.util.XMLParseErrorException;
import daruma.xml.DeclaredName ;
import daruma.xml.Lexicon ;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

import daruma.storage_manager.StorageManager;
import daruma.storage_manager.DBMSStorageManager;
import daruma.storage_manager.type_definition.TypeDefinition;
import daruma.storage_manager.type_definition.TypeException;

import daruma.geometry.TransformationContext;

import daruma.sql.SQLDataType;
import daruma.sql.SQLDataTypeConstant;
import daruma.sql.TableColumnDefinition;
import daruma.sql.SQLTimeFormatConverter;

import daruma.util.ISO8601DateFormat;
import daruma.util.LogWriter;

import java.util.Date;
import java.text.ParsePosition;

import java.util.List;
import java.util.Map;
import java.util.HashMap;

import daruma.util.Itk ;


public class PropertyComparationPredicateDescription
    extends PredicateDescription
{
    private	String		sqlOperator;
    private	String		sqlExpression;

    /* !!! [06/10/16 15:34 I.Noda] !!! 
     * FIXME:
     * ϤΤϡŪexpressionбǤ褦ˤƤʤ
     * ޤ
     */
    private     String		propertyXPath ;
    private	Element		xpathContext ;
    private	String		value ;

    private	static DeclaredName.Table<String> operatorTable ;

    static
    {
	operatorTable = new DeclaredName.Table<String> () ;
	operatorTable.put( Lexicon.MispFilterPropertyIsEqualTo, "=" );
	operatorTable.put( Lexicon.MispFilterPropertyIsLessThan, "<" );
	operatorTable.put( Lexicon.MispFilterPropertyIsGreaterThan, ">" );
	operatorTable.put( Lexicon.MispFilterPropertyIsLessThanOrEqualTo, 
			   "<=" );
	operatorTable.put( Lexicon.MispFilterPropertyIsGreaterThanOrEqualTo, 
			   ">=" );
    }

    public	static	boolean	isAcceptablePredicate( String  localName )
    {
	/* <<< [06/10/16 15:34 I.Noda] <<< */
	//return( PropertyComparationPredicateDescription
	//	.operatorMap.containsKey( localName ) );
	/* === [06/10/16 15:34 I.Noda] === */
	return( PropertyComparationPredicateDescription
		.operatorTable.getByLocalName( localName ) != null );
	/* >>> [06/10/16 15:34 I.Noda] >>> */
    }


    public	PropertyComparationPredicateDescription
		( Element  comparePredicateElement ,
		  TypeDefinition  type ,
		  TransformationContext trans ,
		  StorageManager  storage )
	throws XMLParseErrorException
    {
	super( storage , type , trans );

	/* <<< [06/10/16 15:34 I.Noda] <<< */
	//this.sqlOperator = PropertyComparationPredicateDescription
	//    .operatorMap.get
	//    ( comparePredicateElement.getLocalName() );
	/* === [06/10/16 15:34 I.Noda] === */
	DeclaredName.Table<String>.Entry entry = 
	    PropertyComparationPredicateDescription
	    .operatorTable.getEntry(comparePredicateElement) ;
	
	this.sqlOperator = entry.getValue() ;
	this.tagName = entry.getName() ;
	/* >>> [06/10/16 15:34 I.Noda] >>> */

	if ( this.sqlOperator == null )
	    {
		throw new XMLParseErrorException
		    ( "cannot handle filter \""
		      + comparePredicateElement.getLocalName() + "\"" );
	    }

	this.sqlExpression = parsePropertyComparation
	    ( comparePredicateElement );
    }

    public	String	getSQLExpression()
    {
	return( this.sqlExpression );
    }

    private	String	parsePropertyComparation( Element  comp )
	throws XMLParseErrorException
    {
	List<Element>	childElements
	    = ElementUtil.getChildElements( comp );

	if ( childElements.size() != 2 )
	    {
		throw new XMLParseErrorException
		    ( "filter \"" + comp.getLocalName() + "\""
		      + " has invalid number of child elements,"
		      + " expected was 2" );
	    }

	/* !!! [06/10/16 15:34 I.Noda] !!! 
	 * Ǥϡӥڥ졼1 propertyName
	 * 2 literal ȷǤƤ뤬
	 * OGC  Filter Encoding εʤǤϡ
	 * ӥڥ졼ΰϰŪ expression Ǥʤ
	 * ʤΤǡʲΥåϴְ㤤
	 * ¤Ϥ⤽⡢ȡ׻ʤɤ
	 * Ҥ뤳ȤǤʤʤ롣
	 * Сadd, sub ʤɤϤɤʤäΤ
	 */

	Element	propertyNameElement = childElements.get(0);
	Element	literalElement      = childElements.get(1);

	// tag name check
	Lexicon.MispPropertyName
	    .matchesOrXmlException(propertyNameElement,
				   "in Property Compariton Operator") ;
	Lexicon.MispLiteral
	    .matchesOrXmlException(literalElement,
				   "in Property Compariton Operator") ;

	String	literalString = ElementUtil.getChildNodesWholeText
	    ( literalElement );

	String	shortXPath;
	try
	    {
		shortXPath = PropertyPathConverter
		    .convertPropertyElementToShortXPath
		    ( propertyNameElement ,
		      super.getStorage() );
	    }
	catch( XMLParseErrorException  e )
	    {
		throw e;
	    }

	String	sqlValueString = this.convertValueToSQL
	    ( shortXPath ,
	      literalString );

	/* !!! [06/08/17 17:28 I.Noda] !!! 
	 * ȤȤΤˡѿ̾Ǥ general 
	 * ΤˤƤ
	 */
	String leftArg = shortXPath ;
	String rightArg = null ;

	/* <<< [06/08/17 17:28 I.Noda] <<< 
	 * shortXPath ƥξ硢̰
	 * ä _transaction_id_ ξ硣
	 */
	if(shortXPath.equals(DBMSStorageManager
			     .ColName_SystemTransactionID)) {
	    rightArg =
		genSubQueryForTransactionSN(literalString) ;
	} else {
	    rightArg = "'" + sqlValueString + "'" ;
	}

	/* >>> [06/08/17 17:28 I.Noda] >>> */

	/* <<< [06/10/16 15:34 I.Noda] <<< 
	 * ѤΤξǼƤ
	 * Ǥä˻ȤƻϤʤ
	 * ƵŪ expression 褦ˤ硢ʬ fix 
	 * ɬפ롣
	 */
	this.propertyXPath = 
	    ElementUtil.getChildNodesWholeText(propertyNameElement) ;
	this.xpathContext = propertyNameElement ;
	this.value = literalString ;
	/* >>> [06/10/16 15:34 I.Noda] >>> */

	return( leftArg + this.sqlOperator + rightArg ) ;
    }


    private	String	convertValueToSQL( String  columnName ,
					   String  value )
	throws XMLParseErrorException
    {
	SQLDataType sqlType = super.getTypeDefinition().getSingleSQLDataType();

	if ( sqlType == null )
	{
	    List<TableColumnDefinition>	columns;

	    try
	    {
		columns = super.getTypeDefinition()
				.getCompositeSQLDataType
				 ( super.getStorage() , null );
	    }
	    catch( TypeException  e )
	    {
		throw new XMLParseErrorException
		    ( "type definition error" , e );
	    }

	    for ( TableColumnDefinition  c  : columns )
	    {
		if ( c.getColumnName().equals( columnName ) )
		{
		    sqlType = c.getSQLDataType();
		    break;
		}
	    }
	}

	/* !!! [06/08/29 11:50 I.Noda] !!! 
	 * ƥ५ΰ
	 */
	if(sqlType == null) {
	    if (columnName.equals(DBMSStorageManager
				  .ColName_SystemTransactionID)) {
		sqlType = new SQLDataType("integer", Integer.class) ;
	    } 
	    else if (columnName.equals(DBMSStorageManager
				       .ColName_SystemCreateTime) ||
		     columnName.equals(DBMSStorageManager
				       .ColName_SystemUpdateTime)) {
		sqlType = SQLDataTypeConstant.TIMESTAMP;
	    }
	}

	if ( sqlType == null )
	{
	    LogWriter.qwrite( "DEBUG" ,
			      "columnName [", columnName, "] not found" );

	    throw new XMLParseErrorException( "property not found" );
	}

	if ( sqlType.isTimeFamilyType() )
	{
	    ISO8601DateFormat dateParser = new ISO8601DateFormat();

	    Date date = dateParser.parse( value , new ParsePosition( 0 ) );

	    if(date == null) {
		throw new XMLParseErrorException
		    ("Illegal datetime format:'" + value + "'"
		     + " It should be yyyy-mm-ddThh:mm:ss.sss"
		     + "[+/-]HH:MM") ;
	    }

	    String dateString = SQLTimeFormatConverter
				  .convertDateToString( date );

	    return( dateString );
	}
	else
	{
	    return( value );
	}
    }


    /* !!! [06/08/17 17:28 I.Noda] !!! */
    /**
     * Ӥ٤° _transaction_id_ ξ硢
     * __transaction_log__  uri  serial number ѹɬפ롣
     * Τ SQL sub query ʸ
     */
    private String genSubQueryForTransactionSN(String uriString) {
	/* !!! [06/08/21 15:38 I.Noda] !!! 
	 * ⤷̤Τ uri Ϳȡnull ǤϤʤ 0 ֤褦ѹ
	 * ̤Τ uri ̵¤Τȸʤ
	 */
	return 
	    "ifnull("
	    + "(" + "select " 
	    + DBMSStorageManager.ColName_TransTabSerialNum
	    + " from " 
	    + DBMSStorageManager.TRANSACTION_LOG_TABLE_NAME
	    + " where " 
	    + DBMSStorageManager.ColName_TransTabURI
	    + "='" + uriString + "'"
	    + ")" 
	    + "," + "0" + ")" ;
    }

    //--------------------------------------------------
    /**
     * ܺ٥å
     * ʤɤΥå̩˹Ԥ2nd pass ν
     */
    public boolean detailedCheck(Node feature) 
	throws XMLParseErrorException
    {
	// ܺ٥åξ硢comparison ɬ
	return true ;
    }
}
