package daruma.geometry;

import java.util.List;
import java.util.ArrayList;

import daruma.geometry.CoordinateSystemTransformation;
import daruma.geometry.TransformationException;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.CoordinateSequence;


public class DrmMultiPoint extends DrmGeometry
{
    private List<DrmPoint> points;

    public DrmMultiPoint()
    {
	this.points = new ArrayList<DrmPoint>();
    }

    public void add( DrmPoint p )
    {
	this.points.add( p );
    }

    public List<DrmPoint> getPoints()
    {
	return this.points;
    }

    public DrmPoint get( int indx )
    {
	return this.points.get( indx );
    }

    @Override
    public DrmMultiPoint transform( CoordinateSystemTransformation trans )
						throws TransformationException
    {
	DrmMultiPoint ret = new DrmMultiPoint();

	for( DrmPoint p : this.points )
	{
	    ret.add( trans.transform( p ) );
	}

	return ret;
    }

    @Override
    public Geometry genGeometry( OgcGeometryFactory geometryFactory )
    {
	CoordinateSequence coords = geometryFactory.newCoords
				    ( this.points.size(), 2 );

	int i = 0;
	for ( DrmPoint p : this.points )
	{
	    if ( p.getDimension() >= 3 )
	    {
		geometryFactory.setCoordinate3D
				( coords, i, p.getX(), p.getY(), p.getZ() );
	    }
	    else
	    {
		geometryFactory.setCoordinate2D
				( coords, i, p.getX(), p.getY() );
	    }

	    ++ i;
	}

	return geometryFactory.createMultiPoint( coords );
    }
}
