/*
 * Decompiled with CFR 0.152.
 */
package daruma.wfs.filter;

import daruma.geometry.TransformationContext;
import daruma.storage_manager.StorageManager;
import daruma.storage_manager.type_definition.TypeDefinition;
import daruma.wfs.filter.FilterParser;
import daruma.wfs.filter.PredicateDescription;
import daruma.xml.SAXExceptionObserver;
import daruma.xml.handler.XSAXDOMCreateHandler;
import daruma.xml.util.XMLParseErrorException;
import java.io.OutputStream;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class FilterHandler
extends XSAXDOMCreateHandler {
    private TypeDefinition type;
    private TransformationContext trans;
    private StorageManager storage;
    private SAXExceptionObserver errorReceiver;
    private PredicateDescription predicate;

    public FilterHandler(OutputStream out, XMLReader parser, boolean isTopLevelHandler, TypeDefinition type, TransformationContext trans, StorageManager storage, SAXExceptionObserver errorReceiver) {
        super(out, parser, isTopLevelHandler);
        this.type = type;
        this.trans = trans;
        this.storage = storage;
        this.errorReceiver = errorReceiver;
        this.predicate = null;
    }

    @Override
    public void xStartElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        if (this.getCurrentNode() != null) {
            // empty if block
        }
        super.xStartElement(uri, localName, qName, attrs);
    }

    @Override
    public void xCharacters(char[] str, int offset, int length) throws SAXException {
        super.xCharacters(str, offset, length);
    }

    public PredicateDescription getPredicate() {
        return this.predicate;
    }

    public String getSQLExpression() {
        if (this.predicate == null) {
            return null;
        }
        return this.predicate.getSQLExpression();
    }

    @Override
    public void xEndDocument() throws SAXException {
        Element filterElement = super.getDocumentElement();
        try {
            this.predicate = FilterParser.parseFilter(filterElement, this.type, this.trans, this.storage, this.getPrefixMap());
        }
        catch (XMLParseErrorException e) {
            SAXParseException se = new SAXParseException(e.getMessage(), super.getLocator(), e);
            se.setStackTrace(e.getStackTrace());
            this.errorReceiver.notifyError(se);
            throw se;
        }
    }

    public boolean detailedCheck(Node feature) throws XMLParseErrorException {
        return this.predicate.detailedCheck(feature);
    }
}

