/*
 * Decompiled with CFR 0.152.
 */
package daruma.storage_manager;

import daruma.geometry.CoordinateSystemTransformation;
import daruma.geometry.CoordinateSystemTransformationDictionary;
import daruma.geometry.DrmEnvelope;
import daruma.geometry.TransformationContext;
import daruma.storage_manager.BulkInsertBuffer;
import daruma.storage_manager.StorageException;
import daruma.storage_manager.schema.XMLSchemaSet;
import daruma.storage_manager.type_definition.ElementName;
import daruma.storage_manager.type_definition.TypeDefinition;
import daruma.storage_manager.type_definition.TypeName;
import daruma.storage_manager.type_definition.TypedInstance;
import daruma.storage_manager.type_definition.TypedInstanceSet;
import daruma.util.Pair;
import daruma.wfs.filter.PredicateDescription;
import daruma.xml.SimpleXPath;
import daruma.xml.UniversalName;
import daruma.xml.util.PrefixMap;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;

public abstract class StorageManager {
    public static final String SHORT_XPATH_SEPARATOR = "$";

    public abstract void setReadOnly(boolean var1) throws StorageException;

    public abstract void reset() throws StorageException;

    public abstract void startTransaction() throws StorageException;

    public abstract void commit() throws StorageException;

    public abstract void rollback() throws StorageException;

    public abstract void registerSchema(Element var1, PrefixMap var2) throws StorageException;

    public abstract XMLSchemaSet getSchemasOfElement(ElementName var1) throws StorageException;

    public abstract XMLSchemaSet getSchemasOfElement(ElementName var1, XMLSchemaSet var2) throws StorageException;

    public abstract XMLSchemaSet getSchemasByNS(String var1) throws StorageException;

    public abstract XMLSchemaSet getSchemasByNS(String var1, XMLSchemaSet var2) throws StorageException;

    public abstract void registerTypeDefinition(TypeName var1, TypeDefinition var2, String var3, long var4, boolean var6) throws StorageException;

    public abstract TypeDefinition getTypeDefinition(TypeName var1) throws StorageException;

    public abstract void registerElementDefinition(ElementName var1, TypeName var2, long var3, boolean var5) throws StorageException;

    public abstract TypeName getElementTypeName(ElementName var1) throws StorageException;

    public abstract List<ElementName> getElementList() throws StorageException;

    public abstract int insertElement(ElementName var1, TypedInstance var2, long var3) throws StorageException;

    public abstract void bulkInsertElement(BulkInsertBuffer var1, long var2) throws StorageException;

    public abstract TypedInstanceSet getTypedInstanceSet(ElementName var1, String var2, String var3, TransformationContext var4, long var5, long var7) throws StorageException;

    public abstract long getCountOfTypedInstanceSet(ElementName var1, String var2, long var3) throws StorageException;

    public abstract DrmEnvelope getEnvelopeOfTypedInstanceSet(ElementName var1, String var2, String var3, long var4) throws StorageException;

    public abstract int deleteElement(ElementName var1, PredicateDescription var2, long var3, boolean var5) throws StorageException;

    public abstract int restoreElement(ElementName var1, PredicateDescription var2, long var3) throws StorageException;

    public abstract int updateElement(ElementName var1, List<Pair<SimpleXPath, String>> var2, PredicateDescription var3, long var4, boolean var6) throws StorageException;

    public abstract List<String> getSubTableValues(String var1, long var2) throws StorageException;

    public abstract void registerUniversalNameIfNotRegistrated(UniversalName var1) throws StorageException;

    public abstract String getUniversalNameID(UniversalName var1) throws StorageException;

    public abstract Date getCurrentTime() throws StorageException;

    public abstract long registerTransactionURI(String var1) throws StorageException;

    public abstract long getTransactionSerialNumber(String var1) throws StorageException;

    public abstract String getMostRecentTransactionURI() throws StorageException;

    public abstract String getMostRecentTransactionURIFor(String var1, String var2) throws StorageException;

    public abstract String getMostRecentTransactionURIFor(UniversalName var1) throws StorageException;

    public String getShortXPathStringForDB(SimpleXPath path) throws StorageException {
        StringBuilder buf = new StringBuilder();
        for (UniversalName name : path.getList()) {
            String id;
            if (buf.length() != 0) {
                buf.append(SHORT_XPATH_SEPARATOR);
            }
            if ((id = this.getUniversalNameID(name)) == null) {
                throw new StorageException("Can't convert path [" + path.toString() + "]");
            }
            buf.append(id);
        }
        if (path.isAttribute()) {
            if (buf.length() != 0) {
                buf.append(SHORT_XPATH_SEPARATOR);
            }
            buf.append("_at_");
            String id = this.getUniversalNameID(path.getAttributeName());
            if (id == null) {
                throw new StorageException("Can't convert path [" + path.toString() + "]");
            }
            buf.append(id);
        }
        return buf.toString();
    }

    public TypeDefinition getElementTypeDefinition(ElementName elementName) throws StorageException {
        TypeName typeName;
        try {
            typeName = this.getElementTypeName(elementName);
        }
        catch (StorageException e) {
            throw new StorageException("type of element \"" + elementName.getLocalName() + "\" in namespace \"" + elementName.getNamespace() + "\" not found", e);
        }
        try {
            return this.getTypeDefinition(typeName);
        }
        catch (StorageException e) {
            throw new StorageException("type definition of type \"" + typeName.getLocalName() + "\" in namespace \"" + typeName.getNamespace() + "\" not found", e);
        }
    }

    public abstract void registerCoordinateSystemTransformation(CoordinateSystemTransformation var1) throws StorageException;

    public abstract CoordinateSystemTransformationDictionary getCoordTransDictionary() throws StorageException;
}

