/*
 * Decompiled with CFR 0.152.
 */
package daruma.util;

import daruma.util.Pair;
import daruma.xml.NameSpace;
import daruma.xml.util.DOMDocumentFactory;
import daruma.xml.util.ElementUtil;
import daruma.xml.util.XMLFormatConverter;
import java.sql.Time;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Itk {
    public static final String DefaultTimeStrFormatPattern = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final DateFormat DefaultTimeStrFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    public static final boolean useDOMResponse = true;
    public static final boolean useDetailedCheck = false;

    public static void dbgMsg(Object object) {
        try {
            if (object == null) {
                Itk.dbgMsg("(null)");
            } else if (object instanceof Node) {
                Itk.dbgMsg(XMLFormatConverter.toString((Node)object));
            } else {
                System.out.println("ITKDBG:" + object.toString());
            }
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
        }
    }

    public static void dbgMsg(String label, Object object) {
        try {
            if (object == null) {
                Itk.dbgMsg(label, "(null)");
            } else if (object instanceof Node) {
                Itk.dbgMsg(label, XMLFormatConverter.toString((Node)object));
            } else {
                System.out.println("ITKDBG[" + label + "]:" + object.toString());
            }
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
        }
    }

    public static String genUriRandom() {
        UUID uuid = UUID.randomUUID();
        return "uri:uuid:" + uuid.toString();
    }

    public static Calendar getCurrentTimeCalendar() {
        String tz = "JST";
        return Calendar.getInstance(TimeZone.getTimeZone(tz));
    }

    public static Date getCurrentTimeDate() {
        return new Date();
    }

    public static Time getCurrentTime() {
        return new Time(Itk.getCurrentTimeDate().getTime());
    }

    public static String getCurrentTimeStr() {
        return Itk.getCurrentTimeStr(DefaultTimeStrFormat);
    }

    public static String getCurrentTimeStr(String formatPattern) {
        return Itk.getCurrentTimeStr(new SimpleDateFormat(formatPattern));
    }

    public static String getCurrentTimeStr(DateFormat form) {
        Date date = Itk.getCurrentTimeDate();
        return form.format(date);
    }

    public static void test() {
        try {
            Document doc = DOMDocumentFactory.create();
            Element root = ElementUtil.genElementSimple(NameSpace.GML, "root", null, doc, doc);
            Element child = ElementUtil.genElementSimple(NameSpace.GML, "child", "child's text", doc, root);
            Pair<String, String> strHeaderTailer = ElementUtil.splitToHeaderTailerStrAt(doc, child, true);
            XMLFormatConverter.print(root, System.out, true);
            Itk.dbgMsg(strHeaderTailer.getFirst());
            Itk.dbgMsg(strHeaderTailer.getSecond());
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (TransformerException te) {
            te.printStackTrace();
        }
    }
}

