/*
 * Decompiled with CFR 0.152.
 */
package daruma.storage_manager.type_definition.types;

import daruma.sql.SQLDataType;
import daruma.storage_manager.type_definition.AbstractSingleTypeDefinition;
import daruma.storage_manager.type_definition.TypeException;
import daruma.xml.util.WhitespaceProceccer;

public class FloatTypeDefinition
extends AbstractSingleTypeDefinition {
    @Override
    public SQLDataType getSingleSQLDataType() {
        return new SQLDataType("double", Double.class);
    }

    @Override
    public String parseValue(String value) throws TypeException {
        String v = WhitespaceProceccer.cutoffEdgeWhitespaces(value);
        try {
            Double.parseDouble(v);
        }
        catch (NumberFormatException e) {
            throw new TypeException("\"" + value + "\" is not a valid float value");
        }
        return v;
    }
}

