/*
 * Decompiled with CFR 0.152.
 */
package daruma.sql;

import daruma.geometry.DrmGeometry;
import daruma.sql.DatabaseConnection;
import daruma.sql.DatabaseConnectionException;
import daruma.sql.SQLTimeFormatConverter;
import daruma.sql.TableColumn;
import daruma.storage_manager.type_definition.ColumnNameFactory;
import daruma.util.ISO8601DateFormat;
import daruma.util.LogWriter;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;

public class TableRecord {
    private List<TableColumn> columns;

    public TableRecord(List<TableColumn> columns) {
        this.columns = columns;
    }

    public void executeInsert(DatabaseConnection db, String tableName, long transactionSN) throws DatabaseConnectionException {
        long id = db.getMaxLongValueFromTable(tableName, "_id_");
        ++id;
        StringBuilder s = new StringBuilder();
        s.append("INSERT INTO `" + tableName + "` (");
        s.append("_transaction_id_");
        s.append(",_create_time_");
        s.append(",_update_time_");
        for (TableColumn c : this.columns) {
            if (c.isEmptyColumn()) continue;
            s.append(",");
            s.append("`");
            s.append(c.getDefinition().getColumnName());
            s.append("`");
        }
        s.append(") VALUES (");
        s.append(Long.toString(transactionSN));
        s.append(",NULL");
        s.append(",NULL");
        int wildcardCount = 0;
        for (TableColumn c : this.columns) {
            if (c.isEmptyColumn()) continue;
            s.append(",");
            Class javaClass = c.getDefinition().getSQLDataType().getJavaClass();
            if (DrmGeometry.class.isAssignableFrom(javaClass)) {
                s.append("GeomFromText('");
                s.append(c.getValue());
                s.append("')");
                continue;
            }
            if (Date.class.isAssignableFrom(javaClass)) {
                Date dateTime;
                ISO8601DateFormat f = new ISO8601DateFormat();
                try {
                    dateTime = f.parse(c.getValue());
                }
                catch (ParseException e) {
                    throw new DatabaseConnectionException(e);
                }
                s.append("\"");
                s.append(SQLTimeFormatConverter.convertDateToString(dateTime));
                s.append("\"");
                continue;
            }
            ++wildcardCount;
            s.append("?");
        }
        s.append(")");
        LogWriter.qwrite("DEBUG", "#", s);
        if (wildcardCount == 0) {
            db.executeUpdate(s.toString());
            return;
        }
        PreparedStatement st = null;
        st = db.prepareStatement(s.toString());
        try {
            int wildcard_index = 1;
            for (int i = 0; i < this.columns.size(); ++i) {
                TableColumn col = this.columns.get(i);
                if (col.isEmptyColumn()) continue;
                Class c = col.getDefinition().getSQLDataType().getJavaClass();
                if (c.equals(String.class)) {
                    st.setString(wildcard_index, col.getValue());
                    ++wildcard_index;
                    continue;
                }
                if (c.equals(Boolean.class)) {
                    boolean value = Boolean.parseBoolean(col.getValue());
                    st.setBoolean(wildcard_index, value);
                    ++wildcard_index;
                    continue;
                }
                if (c.equals(Double.class)) {
                    double value = Double.parseDouble(col.getValue());
                    st.setDouble(wildcard_index, value);
                    ++wildcard_index;
                    continue;
                }
                if (c.equals(Float.class)) {
                    float value = Float.parseFloat(col.getValue());
                    st.setFloat(wildcard_index, value);
                    ++wildcard_index;
                    continue;
                }
                if (Date.class.isAssignableFrom(c) || DrmGeometry.class.isAssignableFrom(c)) continue;
                st.setString(wildcard_index, col.getValue());
                ++wildcard_index;
            }
            db.executeUpdate(st);
            st.close();
        }
        catch (SQLException e) {
            throw new DatabaseConnectionException(e.getMessage(), e);
        }
        this.executeInsertToSubTable(db, id);
    }

    private void executeInsertToSubTable(DatabaseConnection db, long parentID) throws DatabaseConnectionException {
        for (TableColumn c : this.columns) {
            if (c.isEmptyColumn() || !c.getDefinition().isExternalTable()) continue;
            String tableName = c.getValue();
            LogWriter.qwrite("DEBUG", "tableName = [", tableName, "]");
            long id = db.getMaxLongValueFromTable(tableName, "_id_");
            ++id;
            for (String v : c.getSubValues()) {
                LogWriter.qwrite("DEBUG", "value = [", v, "]");
                String sql = "INSERT INTO `" + c.getValue() + "` (`_id_`,`_parent_id_`, `" + ColumnNameFactory.getTopLevelElementColumnName() + "`) VALUES (" + id + "," + parentID + ",?)";
                PreparedStatement st = null;
                st = db.prepareStatement(sql);
                LogWriter.qwrite("DEBUG", "#", sql);
                try {
                    st.setString(1, v);
                    db.executeUpdate(st);
                    st.close();
                }
                catch (SQLException e) {
                    throw new DatabaseConnectionException(e.getMessage(), e);
                }
            }
        }
    }
}

