/*
 * Decompiled with CFR 0.152.
 */
package daruma.server;

import daruma.server.ConnectionHandler;
import daruma.sql.DatabaseConnectionException;
import daruma.sql.MySQLDatabaseConnectionFactory;
import daruma.util.Itk;
import daruma.util.LogWriter;
import daruma.util.PortNumberValidator;
import daruma.util.PropertyReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;

public class DarumaDaemon {
    public static final int DEFAULT_PORT = PropertyReader.getProperty("daruma.serv.port", 5050);
    public static final String DEFAULT_DATABASE_NAME = "daruma$devel";
    public static final String DEFAULT_USER = PropertyReader.getProperty("daruma.db.uid", "daruma");
    public static final String DEFAULT_PASSWORD = PropertyReader.getProperty("daruma.db.pass", "");
    public static final String DEFAULT_CONNECTION_LOG_DIRECTORY = ".";
    private int port;
    private String databaseName;
    private String user;
    private String password;
    private boolean debug;
    private boolean useGzipForReceiving;
    private boolean useGzipForSending;
    private boolean connectionLog;
    private File connectionLogDirectory;
    private long connectionID;

    public DarumaDaemon(int port, String databaseName, String user, String passwordm, boolean useGzipForReceiving, boolean useGzipForSending) {
        this.port = port;
        this.debug = false;
        this.useGzipForReceiving = useGzipForReceiving;
        this.useGzipForSending = useGzipForSending;
        this.connectionLog = false;
        this.connectionLogDirectory = null;
        this.databaseName = databaseName;
        this.user = user;
        this.password = this.password;
        this.connectionID = 0L;
    }

    public boolean run() {
        try {
            if (!PortNumberValidator.check(this.port)) {
                LogWriter.qwrite("ERROR", "configuration error: invalid port number: ", this.port);
                System.err.println("invalid port number: " + this.port);
                return false;
            }
            ServerSocket socket = new ServerSocket(this.port);
            LogWriter.qwrite("INFO", "[" + Itk.getCurrentTimeStr() + "] ", "Listen:", socket);
            while (true) {
                ConnectionHandler c;
                Socket s = socket.accept();
                try {
                    c = new ConnectionHandler(s.getInputStream(), s.getOutputStream(), this.databaseName, this.user, this.password, this.useGzipForReceiving, this.useGzipForSending, s.toString(), this.debug, this.connectionLog, this.connectionLogDirectory, this.connectionID);
                    ++this.connectionID;
                }
                catch (DatabaseConnectionException e) {
                    LogWriter.qwrite("ERROR", e.getMessage());
                    continue;
                }
                Thread th = new Thread(c);
                th.start();
            }
        }
        catch (BindException e) {
            LogWriter.qwrite("ERROR", "Can't bind server socket: ", e.getMessage());
            System.err.println("Can't bind server socket: " + e.getMessage());
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setConnectionLog(boolean connectionLog, File connectionLogDirectory) {
        this.connectionLog = connectionLog;
        this.connectionLogDirectory = connectionLogDirectory;
    }

    public static void main(String[] args) {
        DarumaDaemonOptionAnalyzer opt = new DarumaDaemonOptionAnalyzer(args, "DarumaDaemon", DEFAULT_PORT, DEFAULT_DATABASE_NAME, DEFAULT_USER, DEFAULT_PASSWORD, DEFAULT_CONNECTION_LOG_DIRECTORY);
        if (!opt.analyze()) {
            opt.printHelp(System.err);
            System.exit(1);
        } else if (opt.getHelp()) {
            opt.printHelp(System.out);
            System.exit(0);
        }
        File connectionLogDirectory = new File(opt.getConnectionLogDirectory());
        if (opt.getConnectionLog()) {
            String err;
            if (connectionLogDirectory.exists()) {
                if (!connectionLogDirectory.isDirectory()) {
                    err = "connection log directory [" + connectionLogDirectory + "] is not a directory";
                    System.err.println(err);
                    LogWriter.qwrite("FATAL", err);
                    System.exit(1);
                }
            } else if (!connectionLogDirectory.mkdirs()) {
                err = "Can't create connection log directory [" + connectionLogDirectory + "]";
                System.err.println(err);
                LogWriter.qwrite("FATAL", err);
                System.exit(1);
            }
        }
        try {
            new MySQLDatabaseConnectionFactory().loadClass();
        }
        catch (DatabaseConnectionException.ClassLoadFailedDatabaseConnectionException e) {
            LogWriter.qwrite("FATAL", "Can't load class: " + e.getFailedClassName());
            throw new RuntimeException("Can't load class: " + e.getFailedClassName());
        }
        catch (DatabaseConnectionException dce) {
            LogWriter.qwrite("FATAL", "Can't load DB class");
            throw new RuntimeException("Can't load DB class: " + dce.getMessage());
        }
        DarumaDaemon daemon = new DarumaDaemon(opt.getPortNumber(), opt.getDatabaseName(), opt.getUser(), opt.getPassword(), opt.getGzipReceive(), opt.getGzipSend());
        daemon.setDebug(opt.getDebug());
        daemon.setConnectionLog(opt.getConnectionLog(), connectionLogDirectory);
        if (!daemon.run()) {
            System.exit(1);
        }
    }

    public static class DarumaDaemonOptionAnalyzer {
        private String[] args;
        private String programName;
        private int portNumber;
        private String databaseName;
        private String user;
        private String password;
        private boolean helpFlag = false;
        private boolean debugFlag = false;
        private boolean connectionLogFlag = false;
        private String connectionLogDirectory = null;
        private boolean gzipReceiveFlag = false;
        private boolean gzipSendFlag = false;

        public DarumaDaemonOptionAnalyzer(String[] args, String programName, int defaultPortNumber, String defaultDatabaseName, String defaultUser, String defaultPassword, String defaultConnectionLogDirectory) {
            this.args = (String[])args.clone();
            this.programName = programName;
            this.portNumber = defaultPortNumber;
            this.databaseName = defaultDatabaseName;
            this.user = defaultUser;
            this.password = defaultPassword;
            this.connectionLogFlag = false;
            this.connectionLogDirectory = defaultConnectionLogDirectory;
        }

        public boolean analyze() {
            for (int index = 0; index < this.args.length; ++index) {
                String arg = this.args[index];
                int numArgs = this.args.length - index - 1;
                if (arg.equals("--help")) {
                    this.helpFlag = true;
                    continue;
                }
                if (arg.equals("--port")) {
                    if (numArgs < 1) {
                        return false;
                    }
                    try {
                        this.portNumber = Integer.parseInt(this.args[index + 1]);
                    }
                    catch (NumberFormatException e) {
                        LogWriter.qwrite("ERROR", "invalid port number: ", this.args[index + 1]);
                        System.err.println("invalid port number: " + this.args[index + 1]);
                        return false;
                    }
                    ++index;
                    continue;
                }
                if (arg.equals("--database")) {
                    if (numArgs < 1) {
                        return false;
                    }
                    this.databaseName = this.args[index + 1];
                    ++index;
                    continue;
                }
                if (arg.equals("--user")) {
                    if (numArgs < 1) {
                        return false;
                    }
                    this.user = this.args[index + 1];
                    ++index;
                    continue;
                }
                if (arg.equals("--password")) {
                    if (numArgs < 1) {
                        return false;
                    }
                    this.password = this.args[index + 1];
                    ++index;
                    continue;
                }
                if (arg.equals("--debug")) {
                    this.debugFlag = true;
                    continue;
                }
                if (arg.equals("--gzip")) {
                    this.gzipReceiveFlag = true;
                    this.gzipSendFlag = true;
                    continue;
                }
                if (arg.equals("--gzip-receive")) {
                    this.gzipReceiveFlag = true;
                    continue;
                }
                if (arg.equals("--gzip-send")) {
                    this.gzipSendFlag = true;
                    continue;
                }
                if (arg.equals("--connection-log")) {
                    this.connectionLogFlag = true;
                    continue;
                }
                if (arg.equals("--connection-log-directory")) {
                    if (numArgs < 1) {
                        return false;
                    }
                    this.connectionLogDirectory = this.args[++index];
                    continue;
                }
                LogWriter.qwrite("invalid option: " + arg, new Object[0]);
                System.err.println("invalid option: " + arg);
                return false;
            }
            return true;
        }

        public void printHelp(OutputStream out) {
            String mes = "";
            mes = mes + "Usage: " + this.programName + " [options]" + "\n";
            mes = mes + "Possible options are:\n";
            mes = mes + "      --help\n";
            mes = mes + "      --port PORT\n";
            mes = mes + "      --database DATABASE_NAME\n";
            mes = mes + "      --user USER_NAME\n";
            mes = mes + "      --password PASSWORD\n";
            mes = mes + "      --debug\n";
            mes = mes + "      --connection-log\n";
            mes = mes + "      --connection-log-directory DIRECTORY\n";
            mes = mes + "      --gzip\n";
            mes = mes + "      --gzip-receive\n";
            mes = mes + "      --gzip-send\n";
            PrintStream p = new PrintStream(out);
            p.print(mes);
        }

        public boolean getHelp() {
            return this.helpFlag;
        }

        public int getPortNumber() {
            return this.portNumber;
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean getDebug() {
            return this.debugFlag;
        }

        public boolean getGzipReceive() {
            return this.gzipReceiveFlag;
        }

        public boolean getGzipSend() {
            return this.gzipSendFlag;
        }

        public boolean getConnectionLog() {
            return this.connectionLogFlag;
        }

        public String getConnectionLogDirectory() {
            return this.connectionLogDirectory;
        }
    }
}

