#　フォント
require 'fontlist'
require 'darkhall/setting'
require 'darkhall/game'
require 'darkhall/logger'

module DarkHall

	class << Game
		attr_reader :regular_ttf, :column_caption_ttf, :page_cursor_ttf, :title_ttf
		attr_reader :char_width, :page_cursor_width, :page_cursor_height
	
		def search_font(font_name)
			default_path = './res/font/' + font_name
			if File.exist?(default_path) then
				return default_path
			else
				return FontList.fontfiles.find{|x| x =~ /#{Regexp.escape(font_name)}$/}
			end
		end
		
		def load_ttf(font_name, size = DEFAULT_TTF_SIZE)
			path = search_font(font_name)
			unless path then
				LOGGER.puts "Warning: TTF #{font_name} not found!"
				path = search_font(DEFAULT_TTF_NAME) || search_font('msgothic.ttf')
			end
			
			@regular_ttf = SDL::TTF.open(path, size)
			@regular_ttf.style = SDL::TTF::STYLE_NORMAL
			@column_caption_ttf = SDL::TTF.open(path, size - 2)
			@column_caption_ttf.style = SDL::TTF::STYLE_NORMAL
			
			@title_ttf = SDL::TTF.open(path, 24)
			@title_ttf.style = SDL::TTF::STYLE_BOLD | SDL::TTF::STYLE_ITALIC

			@page_cursor_ttf = @regular_ttf
			
			@char_width = @regular_ttf.text_size(' ')[0]
			
			@page_cursor_width, @page_cursor_height = @page_cursor_ttf.text_size('▼')
			
			LOGGER.puts "TTF font loaded - #{path}"
		end
		
		def reload_ttf(conf = GS.game_config)
			load_ttf(conf.ttf_name, conf.ttf_size)
			$windows.each{|x| x.update}
		end
	end

	
	
	SDL::TTF.init
	Game.load_ttf(DEFAULT_TTF_NAME)
	
	
end

