# 色々なクラス
module DarkHall
	module InstanceFromModel
		attr_reader :data_id
		def initialize(data_id)
			super()
			@data_id = data_id
		end
		
		def data
			raise
		end
		
		def method_missing(message, *arg)
	    self.data.send(message, *arg)
		end
		
		
	end
	
	class ModelInstance
		include InstanceFromModel
	end
	
	class Model
		include GetText
		attr_accessor :id
	
		private
		def initialize(id = '?', parameters = {})
			@id = id.to_s
			init_params
			return unless parameters
			parameters.each_pair do |key, value|
				instance_variable_set("@#{key.to_s}", value)
			end
		end
		
		def init_params
			
		end
	end
	
	
=begin
	class ModelList
		attr_reader :models
	
		def initialize
			super
			@models = []
			@cache_table = {}
		end
		
		def clear
			@models.clear
			@cache_table.clear
		end
	
		
		def [](id)
			if @cache_table[id] then
				@cache_table[id]
			else
				re = @models.find{|x| x.id == id}
				@cache_table[id] = re
				
				re
			end
		end
		
		def load_file(path)
			if File.readable?(path) then
				script = File.read(path)
				self.instance_eval(script, path)
				return true
			else
				return false
			end
		end
		
		def each(&proc)
			@models.each(&proc)
		end
		
		private
		def add(model_class, id, &proc)
			model = model_class.new
			if proc then
				model.instance_eval(&proc)
			end
			model.id = id
			@models << model

		end

	end
	
	class ItemModelList < ModelList
	end

	class SpellModelList < ModelList
		def spell(id, trick_ids)
			add(SpellModel, id){
				@trick_ids = trick_ids
			}
		end
	end

	
	class TrickModelList < ModelList
		def trick(id, &proc)
			add(SpellTrickModel, id, &proc)
		end
	end
=end

	


	
		
	
	
	

end
	
