# 武器
module DarkHall
	# 武器を持ち換える
	# アクセサリーを変更する
	# 武器を拾う
	#
	# ダガー
	# ボーイーナイフ
	# ショートソード
	# ロングソード
	# バスタードソード
	# ツーハンドソード
	# 黒曜石の剣
	# グレートソード
	# クレイモア
	# ロングスピア
	# ランス
	# ハルバード
	# 手斧
	# 戦斧
	# ブーメラン
	# 手裏剣
	# チャクラム
	# 矢
	# ボルト
	# セスタス
	# バックラー
	# 盾
	#
	# 致傷力    材質の鋭さ×武器系統補正
	# 重量      材質の重量×武器系統補正
	# ディレイ  武器系統基本値×柔軟性補正
	#
	# 鋭さ/重量/柔軟性
	# 鉄 (Iron)
	# 鋼鉄 (Steel)
	# 木 (Wood)
	# 霊木 (Hallowed Wood)
	# 世界樹 (Yugdrasil)
	# 獣革 (Beast Leather)
	# 竜鱗 (Dragon Leather)
	# 黒曜石 (Obsidian)
	# 古代樹 (Ancient Wood)
	# ルビー
	# 神鉄 (Divine Metal)
	# ブルークリスタル (Blue Crystal)
	#
	# 普通の (Standard)
	# 頑丈な (Hard)     
	# 丈夫な (Strong)    
	# 鋭い (Sharp)      ダメージ上昇
	# 精巧な (Sophisticated)
	# 達人の (Master)
	# 粗悪な (Bad)
	# 神秘的な (Mysterious)
	# 豪華な (Gorgeous) 
	# 驚異の (Incredible)
	# 美しい (Beautiful)
	# 良質な (Good) 
	# 魔法使いの (Magical)
	# 聖なる (Holy)
	# 祝福された (Blessed)
	# 邪悪な (Dark)
	# 呪われた (Cursed)
	# 壊れた/破れた (Broken)
	
	# 普通の鋼鉄製ロングソード (Standard Long Sword of Steel)
	# 達人の黒曜石製日本刀 (Master Samurai Sword of Obsidian)
	# 祝福された木製矢 (Blessed Arrow of Wood)
	# 精巧な鋼鉄製
	
	
	class EquipmentModel < ItemModel
		attr_accessor :str_bonus, :tec_bonus, :agl_bonus, :vit_bonus
		attr_accessor :int_bonus, :wil_bonus, :psy_bonus, :cha_bonus
		attr_accessor :hitting_bonus, :avoid_bonus, :damage_resists, :state_resists, :constant_status
		attr_accessor :protection_damage_types, :protection_rate
		bool_attr_accessor :no_arange
		
		def init_params
			super
			@str_bonus = 0
			@tec_bonus = 0
			@agl_bonus = 0
			@vit_bonus = 0
			@int_bonus = 0
			@wil_bonus = 0
			@psy_bonus = 0
			@cha_bonus = 0
			@hitting_bonus = 0
			@avoid_bonus = 0
			
			@damage_resists = {}
			@state_resists = {}
			@protection_damage_types = []
			@protection_rate = 0
			
			@constant_status = []
			@no_arange = false
			
		end
		
		def matched_prefix?(prefix)
			true
		end
		
		
	
	end
	
	
	
	


	class WeaponModel < EquipmentModel
		attr_accessor :weapon_type, :damage_rate
		attr_accessor :damage_types, :long_range, :double_handed
		bool_attr_accessor :ghost_slayer
		attr_accessor :attack_number, :attack_parameters
		attr_accessor :message_type
		attr_reader :attack_messages, :ranpage_messages
		attr_reader :smash_messages
		
		def init_params
			super
			@attack_parameters = []
			@product_type = PD_WEAPON
			@treasure_type = TRT::WEAPON
			@ghost_slayer = false
		end
		

		
		def get_message(attack_type)
			if @message_type and (list = DB.attack_message_table[@message_type][attack_type]) then
				Util.random_pick(list)
			else
				nil
			end		

		end
		
		def get_attack_message
			get_message(:attack)
		end
		
		def get_ranpage_message
			get_message(:ranpage)
		end
		
		def get_smash_message
			get_message(:smash)
		end
		
		def get_sneak_attack_message
			get_message(:sneak_attack)
		end
		
		

		
	end
	
	

	
	module MagicWeapon
		attr_accessor :magic_power_rate, :magic_control_bonus
	end
	
	
	
	
	class FistModel < WeaponModel
	
		def init_params
			super
			@long_range = false
			@double_handed = true
			@damage_types = [DT_BLOW]
			@attack_parameters = [STR]
			@attack_number = 5


		end
		
	end


	

	
	
	
	class ShortSwordModel < WeaponModel
	
	
		def init_params
			super
			@black_name = _("？短剣")
			@long_range = false
			@double_handed = false
			@damage_types = [DT_SLASH]
			@attack_number = 3
			@avoid_bonus = +3
			@attack_parameters = [STR]
			@message_type = :ShortSword
		end
		
		def matched_prefix?(prefix)
			case prefix
			when IP::Sophisticated, IP::Heavy
				return false
			end
			return super
		end

		
		def usable_by?(member)
			case member
			when Fighter, HeavyFighter, Magician, Explorer, Academian, Prayer
				return true
			else
				return false
			end
		end

	end

	
	class SwordModel < WeaponModel
	
	
		def init_params
			super
			@black_name = _("？長剣")
			@long_range = false
			@double_handed = false
			@damage_types = [DT_SLASH]
			@attack_number = 3
			@avoid_bonus = +2
			@attack_parameters = [STR]
			@message_type = :Sword

		end
		def matched_prefix?(prefix)
			case prefix
			when IP::Sophisticated
				return false
			end
			return super
		end
		
		def usable_by?(member)
			case member
			when Fighter, HeavyFighter
				return true
			else
				return false
			end
		end

	end
	
	class AxeModel < WeaponModel
	
	
		def init_params
			super
			@black_name = _("？斧")
			@long_range = false
			@double_handed = false
			@damage_types = [DT_SLASH, DT_BLOW]
			@attack_number = 2
			@attack_parameters = [STR]
			@message_type = :Axe

		end
		def matched_prefix?(prefix)
			case prefix
			when IP::Sophisticated
				return false
			end
			return super
		end
		
		def usable_by?(member)
			case member
			when Fighter, HeavyFighter
				return true
			else
				return false
			end
		end

	end

	
	class LargeSwordModel < WeaponModel
	
	
		def init_params
			super
			@black_name = _("？大剣")
			@long_range = false
			@double_handed = true
			@attack_parameters = [STR]
			@damage_types = [DT_SLASH, DT_BLOW]
			@attack_number = 2
			@message_type = :LargeSword
	
	
		end
		def matched_prefix?(prefix)
			case prefix
			when IP::Sophisticated
				return false
			end
			return super
		end
		
		def usable_by?(member)
			case member
			when HeavyFighter
				return true
			else
				return false
			end
		end

	end
	
	
	class SpearModel < WeaponModel
	
	
		def init_params
			super
			@black_name = _("？槍")
			@long_range = false
			@double_handed = false
			@attack_parameters = [STR]
			@damage_types = [DT_THRUST]
			@attack_number = 2
			@message_type = :Spear
		end
		
		def usable_by?(member)
			case member
			when Fighter, HeavyFighter
				return true
			else
				return false
			end
		end

		
	end
	
	class LargeSpearModel < WeaponModel
	
		def init_params
			super
			@black_name = _("？騎兵槍")
			@long_range = false
			@double_handed = true
			@attack_parameters = [STR]
			@damage_types = [DT_THRUST]
			@attack_number = 1
			@avoid_bonus = -2
			@message_type = :LargeSpear

		end
		def matched_prefix?(prefix)
			case prefix
			when IP::Sharp, IP::Sophisticated
				return false
			end
			return super
		end
		
		def usable_by?(member)
			case member
			when HeavyFighter
				return true
			else
				return false
			end
		end

	end

	class ClubModel < WeaponModel
	
		def init_params
			super
			@black_name = _("？棒")
			@long_range = false
			@double_handed = false
			@damage_types = [DT_BLOW]
			@attack_parameters = [STR]
			@attack_number = 3
			@message_type = :Club

		end
		def matched_prefix?(prefix)
			case prefix
			when IP::Sharp, IP::Sophisticated
				return false
			end
			return super
		end
		
		def usable_by?(member)
			case member
			when Fighter, HeavyFighter, Explorer, Magician, Academian, Prayer
				return true
			else
				return false
			end
		end

	end
	
	class HammerModel < WeaponModel
	
		def init_params
			super
			@black_name = _("？槌")
			@long_range = false
			@double_handed = true
			@damage_types = [DT_BLOW]
			@attack_parameters = [STR]
			@attack_number = 1
			@message_type = :Hammer

		end
		def matched_prefix?(prefix)
			case prefix
			when IP::Sharp, IP::Sophisticated
				false
			else
				super
			end
		end
		
		def usable_by?(member)
			case member
			when HeavyFighter
				return true
			else
				return false
			end
		end

	end


	
	class BowModel < WeaponModel
	
	
		def init_params
			super
			@black_name = _("？弓")
			@long_range = true
			@double_handed = true
			@attack_parameters = [STR, WIL]
			@damage_types = [DT_THRUST]
			@attack_number = 1
			@message_type = :Bow

		end

		def matched_prefix?(prefix)
			case prefix
			when IP::Sharp, IP::Hard
				return false
			end
			return super
		end
		
		def usable_by?(member)
			case member
			when Archer
				return true
			else
				return false
			end
		end

	end
	
	class AutoBowModel < WeaponModel

	
		def init_params
			super
			@black_name = _("？自動弓")
			@long_range = true
			@double_handed = false
			@attack_parameters = [TEC]
			@damage_types = [DT_THRUST]
			@attack_number = 1
			@message_type = :AutoBow
		end
		def matched_prefix?(prefix)
			false
		end
		
		def usable_by?(member)
			true
		end

	end
	
	class WandModel < WeaponModel
		include MagicWeapon
	
	
		def init_params
			super
			@black_name = _("？杖")
			@long_range = false
			@double_handed = false
			@attack_parameters = [STR]
			@damage_types = [DT_BLOW]
			@attack_number = 3
			@damage_rate = 0.5
			@magic_power_rate = 1.0
			@magic_control_rate = 1.0
			@message_type = :Club
		end
		def matched_prefix?(prefix)
			case prefix
			when IP::Sharp, IP::Hard, IP::Sophisticated
				return false
			end
			return super
		end
		
		def usable_by?(member)
			case member
			when Magician, Academian
				return true
			else
				return false
			end
		end

	end





	
	

	
	
	
	# 敵の武器
	class CrowModel < WeaponModel
	
		def init_params
			super
			@long_range = false
			@double_handed = true
			@damage_types = [DT_SLASH]
			@attack_parameters = [STR]
			@attack_number = 3
			@message_type = :Crow
		end
		
	end
	
	class VineModel < WeaponModel
	
		def init_params
			super
			@long_range = false
			@double_handed = true
			@damage_types = [DT_BLOW]
			@attack_parameters = [STR]
			@attack_number = 2
			@message_type = :Vine

		end
		
	end

	
	class SpiritBodyModel < WeaponModel
	
		def init_params
			super
			@damage_types = []
			@attack_number = 1
			@attack_parameters = [STR]
			@message_type = :SpiritBody

		end
		
	end
	
	class SlimeBodyModel < WeaponModel
	
		def init_params
			super
			@damage_types = []
			@attack_number = 1
			@attack_parameters = [STR]
			@message_type = :SlimeBody

		end
		
	end

	
	class BeakModel < WeaponModel
	
		def init_params
			super
			@long_range = true
			@damage_types = [DT_THRUST]
			@attack_parameters = [STR, AGL]
			@attack_number = 2
			@message_type = :Beak


		end
		
	end



	
	
	class ArmorModel < EquipmentModel
		attr_accessor :defense
		
		def init_params
			super
			@product_type = PD_ARMOR
			@treasure_type = TRT::ARMOR

		end
		
		def matched_prefix?(prefix)
			return !([IP::Sharp, IP::Sophisticated].include?(prefix))
		end

	end

	class LightArmorModel < ArmorModel
		def init_params
			super
			@black_name = _("？軽鎧")
		end
		def usable_by?(member)
			case member
			when Academian
				return false
			else
				return true
			end
		end
	end

	class HeavyArmorModel < ArmorModel
		def init_params
			super
			@black_name = _("？重鎧")
		end
		def usable_by?(member)
			case member
			when HeavyFighter
				return true
			else
				return false
			end
		end
	end
	
	
	
	class CloakModel < ArmorModel
		def init_params
			super
			@black_name = _("？外套")
			@product_type = PD_ACCESSORY
		end
		
		def matched_prefix?(prefix)
			case prefix
			when IP::Standard, IP::Good, IP::Bad, IP::Decorated, IP::Gorgeous, IP::Cursed
				true
			else
				false
			end
		end

	end
	
	
	
	
	
	
	
	class AccessoryModel < EquipmentModel
		attr_accessor :defense
		
		def matched_prefix?(prefix)
			false
		end
		
		def init_params
			super
			@product_type = PD_ACCESSORY
			@treasure_type = TRT::ACCESSORY
			@defense = 0
		end
		
	end
	
	class InnerArmorModel < AccessoryModel
		def init_params
			super
			@product_type = PD_ARMOR
		end
	end
	
	class ArmGuarderModel < AccessoryModel
		def matched_prefix?(prefix)
			return !([IP::Sharp, IP::Sophisticated].include?(prefix))
		end
		
		def init_params
			super
			@product_type = PD_ARMOR
		end

	end
	
	class ShieldModel < AccessoryModel
		attr_accessor :guard_bonus, :extra_defense

		def init_params
			super
			@guard_bonus = 0
			@black_name = _("？盾")
			@product_type = PD_ARMOR
			@treasure_type = TRT::ARMOR
		end

		
		#def matched_prefix?(prefix)
		#	return !([IP::Sharp, IP::Sophisticated].include?(prefix))
		#end
		

	end

	
	class SmallShieldModel < ShieldModel
		def guard_border
			return 60 + @guard_bonus
		end

		def usable_by?(member)
			case member
			when Fighter, Explorer, HeavyFighter, Archer, Prayer
				return true
			else
				return false
			end
		end
	end
	
	class LargeShieldModel < ShieldModel
		def guard_border
			return 70 + @guard_bonus
		end

		def usable_by?(member)
			case member
			when HeavyFighter, Archer
				return true
			else
				return false
			end
		end
	end

	
	
	




	
	class Equipment < Item
		attr_accessor :prefix
	
		def initialize(data_id, prefix = IP::Standard)
			super(data_id)
			@prefix = prefix
		end	
		
		def name
			if not unidentified? and ITEM_PREFIX_CAPTIONS[@prefix] then
				return(ITEM_PREFIX_CAPTIONS[@prefix] + super)
			else
				return super
			end
		end
		
		
		def extra_captions
			captions = super.dup
			case @prefix
			when IP::Master
				captions << _("熟練限界200%")
			end
			
			return captions
		end
		
		def price
			price = self.data.price
			case @prefix
			when IP::Broken
				return(price / 5)
			when IP::Bad
				return (price / 2)
			when IP::Good
				return (price * 1.5).to_i

			when IP::Gorgeous
				return(price * 5)
			when IP::Master
				return(price * 10)
			else
				return price
			end
		end
		
		
		
		def set_prefix
			unless no_arange? then
				# 20回まで試行する
				20.times do
					@prefix = random_pick(ITEM_PREFIX_TABLE)
					next unless self.matched_prefix?(@prefix)
					return self
				end
				
				@prefix = IP::Standard
			end
			return self
		end
		
		def dump
			hash = super
			hash['prefix'] = @prefix
			return hash
		end
		
		def self.create_from_mpac_model(hash)
			obj = super
			obj.prefix = hash['prefix']

			return obj
		end

	end
	
	class Weapon < Equipment
		def item_type_caption
			re = ''
			re << (long_range ? _("遠距離武器") : _("近距離武器"))
			re << (double_handed ? _(" (両手)") : "")
			
			re
		end
		
		def spec_caption_texts
			re = []
			if data.kind_of?(WandModel) then
				re << [_("術威力"), (magic_power_rate * 10).to_i]
				re << [_("術制御"), Util.bonus_to_s(magic_control_bonus)]
			else
				re << [_("属性"), Util.get_damage_type_caption(damage_types)]
				n = attack_number
				re << [_("武器威力"), "#{(damage_rate * 10).to_i}×" + n_("%{n}回", "%{n}回", n).evaluate(:n => n)]
			end
			
			# 命中
			hit_label = s_("Bonus|命中")
			avd_label = s_("Bonus|回避")
			if hitting_bonus != 0 and avoid_bonus != 0 then
				re << "#{hit_label}#{Util.bonus_to_s(hitting_bonus)} / #{avd_label}#{Util.bonus_to_s(avoid_bonus)}"
			elsif hitting_bonus != 0 then
				re << "#{hit_label}#{Util.bonus_to_s(hitting_bonus)}"
			elsif avoid_bonus != 0 then
				re << "#{avd_label}#{Util.bonus_to_s(avoid_bonus)}"
			end

			
			re
		end

		

		def damage_rate
			case @prefix
			when IP::Heavy
				data.damage_rate + 0.3
			when IP::Sharp, IP::Cursed
				data.damage_rate + 0.2
			when IP::Good
				data.damage_rate + 0.1
			when IP::Bad, IP::Light
				data.damage_rate - 0.1
			when IP::Broken
				data.damage_rate - 0.2
			else
				data.damage_rate
			end
		end
		
		def power(actor)
			params = data.attack_parameters
			value = 0
			params.each do |param|
				value += (actor.get_ability(param) / params.size)
			end
			return(value * self.damage_rate).to_i
		end
		
		alias attack power
		
		def hitting_bonus
			case @prefix
			when IP::Sophisticated, IP::Light
				data.hitting_bonus + 4
			when IP::Good
				data.hitting_bonus + 2
			when IP::Bad
				data.hitting_bonus - 2
			when IP::Heavy, IP::Broken
				data.hitting_bonus - 4
			else
				data.hitting_bonus
			end
		end
		
	
		HAND = Weapon.new('Hand')
	
	end

	
	class Armor < Equipment
		def item_type_caption
			_("体防具")
		end
		
		def spec_caption_texts
			re = []
			
			re << [_("防護力"), defense]
			re << [_("回避補正"), Util.bonus_to_s(avoid_bonus)]
			#re << [_("耐性"), ""]
			
			re
		end
		
		def defense
			case @prefix
			when IP::Hard
				data.defense + 2
			when IP::Good
				data.defense + 1
			when IP::Bad, IP::Light
				data.defense - 1
			when IP::Broken
				data.defense - 2
			else
				super
			end
		end

		def avoid_bonus
			case @prefix
			when IP::Light
				data.avoid_bonus + 2
			when IP::Good
				data.avoid_bonus + 1
			when IP::Bad
				data.avoid_bonus - 1
			when IP::Broken
				data.avoid_bonus - 2
			else
				super
			end
		end
	
	end

	class Accessory < Equipment
		def item_type_caption
			case data
			when LargeShieldModel
				_("大型の盾")
			when SmallShieldModel
				_("小型の盾")
			else
				_("アクセサリー")
			end
		end
		
		def spec_caption_texts
			re = []
			
			# 盾の表示
			if data.kind_of?(ShieldModel) then
				re << [_("追加防護力"), sprintf("+%d", extra_defense)]
			end

			
			# 能力値修正
			buf = []
			ABILITY_TYPES.each do |type|
				bonus = self.send(BONUS_METHOD_NAME_TABLE[type])
				if bonus != 0 then
					buf << (ABILITY_CAPTIONS[type] + Util.bonus_to_s(bonus))
				end
			end
			unless buf.empty? then
				re << buf.join('/')
			end
			
			# 命中・回避・防護力の表示
			if self.hitting_bonus != 0 then
				re << (s_('Bonus|命中') + Util.bonus_to_s(self.hitting_bonus))
			end

			if self.avoid_bonus != 0 then
				re << (s_('Bonus|回避') + Util.bonus_to_s(self.avoid_bonus))
			end

			if self.defense != 0 then
				re << (_('防護力') + Util.bonus_to_s(self.defense))
			end
			
			
			re
		end	
	end

	


end