<?php
/**
 * 
 * WheremancyLiteral
 * 
 * 
 * 　プレースホルダ（「?」）を使わず、入力したWHERE条件をそのまま
 * 実行したいときに使います。
 * 
 * PHP version 5
 * @package Daomancy
 * @version Release: 0.1.0
 * @author y.terrashima
 */

class WheremancyLiteral extends Wheremancy
{
	protected function __construct($where , $params = array())
	{
		$this->where = $where;
	}
	
	public static function &_($where , $params = array())
	{
		$where = new self($where);
		return $where;
	}
	
	public static function &where($where , $params = array())
	{
		return self::_($where , $params);
	}
	
	public function toSQL($isRoot = true)
	{
		$sql = '';
		$conjunction = '';
		$nextSql = '';
		$thisSql = $this->where;
		if($this->next) {
			$nextSql = $this->next->toSQL(false);
			if(!$this->where && preg_match('/( AND | OR )/' , $nextSql)) {
				$nextSql = '(' . $nextSql . ')';
			}
		}
		if($thisSql && $nextSql) {
			$conjunction = $this->_getConjunction();
		}
		if($isRoot) {
			$sql = ' WHERE ';
		}
		$sql .= $thisSql . $conjunction . $nextSql;
		
		return $sql;
	}
	
}

?>