<?php

class MultiWrapper
{
    protected $callbacks = array('htmlspecialchars' ,);
    
    public function __construct($callbacks = null)
    {
        if(!is_null($callbacks)) {
            $this->callbacks = (array)$callbacks;
        }
    }
    
    public function wrap($in)
    {
        if($in === null) {
            return null;
        } elseif(is_scalar($in)) {
            $ret = $in;
            foreach($this->callbacks as $v) {
                $ret = call_user_func($v , $ret);
            }
            return $ret;
        }elseif(is_object($in)) {
            return new _MultiWrapper(array($this , __FUNCTION__) , $in);
        } elseif(is_array($in)) {
            $ret = array_map(
                array($this , __FUNCTION__) , $in);
            return $ret;
        }
        return $in;
    }
}

class _MultiWrapper
{
    private $____target;
    private $____wrapper;
    
    public function __construct($wrapper , $target)
    {
        $this->____wrapper = $wrapper;
        $this->____target = $target;
    }
    
    public function __call($method , $param)
    {
        $ret = call_user_func_array(
            array($this->____target , $method)
            , $param);
        return call_user_func($this->____wrapper , $ret);
    }
    
    public function __get($k)
    {
        $ret = $this->_____target->{$k};
        return $call_user_func($this->____wrapper , $ret);
    }
    
    public function __set($k , $v)
    {
        $ret = $this->_____target->{$k} = $v;
    }
    
    public function __isSet($k)
    {
    	return isset($this->_____target->{$k});
    }
    
    public function __unset($k)
    {
    	return unset($this->_____target->{$k});
    }
    
}

?>