var sortOrder1st = "compareDate";
var sortOrder2nd = "compareDate";

// 日付昇順
function compareDate(result1, result2) {
	var ret;
	if (result1.date > result2.date) {
		ret = 1;
	} else if (result1.date < result2.date) {
		ret = -1;
	} else {
		ret = 0;
	}
	return ret;
}

// 日付降順
function compareDateDesc(result1, result2) {
	return compareDate(result2, result1);
}

// ID昇順
function compareId(result1, result2) {
	var ret;
	if (result1.id > result2.id) {
		ret = 1;
	} else if (result1.id < result2.id) {
		ret = -1;
	} else {
		ret = 0;
	}
	return ret;
}

// ID降順
function compareIdDesc(result1, result2) {
	return compareId(result2, result1);
}

// 得点昇順
function compareScore(result1, result2) {
	return (result1.score - result2.score);
}

// 得点降順
function compareScoreDesc(result1, result2) {
	return compareScore(result2, result1);
}

// 音程昇順
function compareInterval(result1, result2) {
	return (result1.interval - result2.interval);
}

// 音程降順
function compareIntervalDesc(result1, result2) {
	return compareInterval(result2, result1);
}

// 表示
function view() {
	document.getElementById("divView").innerHTML = "";
	
	var str = "";
	str += "<table>"
		+ "<tr><th class='score' rowspan='3'>得点</th><th class='title' colspan='8'>タイトル</th><th class='id' colspan='3'>ID</th></tr>"
		+ "<tr><th class='artist' colspan='8'>アーティスト</th><th class='date' colspan='3'>日付</th></tr>"
		+ "<tr><th class='vibrato'>ビブラート</th><th class='shakuri'>しゃくり</th><th class='kobushi'>こぶし</th><th class='fall'>フォール</th><th class='interval'>音程</th><th class='lowTone'>低音</th><th class='highTone'>高音</th><th class='vibratoSkill'>ビブラートの上手さ</th><th class='longTone'>ロングトーンの上手さ</th><th class='modulation'>抑揚</th><th class='rhythm'>リズム</th></tr>";
	
	for (var j = 0; j < results.length; j++) {
		str += "<tr><td class='score' rowspan='3'>" + results[j].score + "</td><td class='title' colspan='8'>" + (songs[results[j].id] ? songs[results[j].id].title : "") + "</td><td class='id' colspan='3'>" + results[j].id + "</td></tr>"
			+ "<tr><td class='artist' colspan='8'>" + (songs[results[j].id] ? songs[results[j].id].artist : "") + "</td><td class='date' colspan='3'>" + results[j].date + "</td></tr>"
			+ "<tr><td class='vibrato'>" + results[j].vibratoTime + "</td><td class='shakuri'>" + results[j].shakuri + "</td><td class='kobushi'>" + results[j].kobushi + "</td><td class='fall'>" + results[j].fall + "</td><td class='interval'>" + results[j].interval + "</td><td class='lowTone'>" + results[j].lowTone + "</td><td class='highTone'>" + results[j].highTone + "</td><td class='vibratoSkill'>" + results[j].vibratoSkill + "</td><td class='longTone'>" + results[j].longTone + "</td><td class='modulation'>" + results[j].modulation + "</td><td class='rhythm'>" + results[j].rhythm + "</td></tr>"
	}
	str += "</table>";
	
	document.getElementById("divView").innerHTML = str;
}

// ソート
function sort() {
	results.sort(eval(sortOrder2nd));
	results.sort(eval(sortOrder1st));
}

// ソート優先順位取得
function changeSortOrder() {
	sortOrder1st = document.getElementById("selecter1st").value;
	sortOrder2nd = document.getElementById("selecter2nd").value;
}

// 初期化
function init() {
	document.getElementById("divSelecter1st").innerHTML += "ソート優先順位1: " + createSelecter("selecter1st");
	document.getElementById("divSelecter2nd").innerHTML += "ソート優先順位2: " + createSelecter("selecter2nd");
	document.getElementById("divButton").innerHTML += "<input type='button' value='ソートして表示' onclick='changeSortOrder();sort();view();'></input>"
	
	sort();
	
	view();
}

// ソート優先順位のselect要素の作成
function createSelecter(idName) {
	var str = "";
	str += "<select id='" + idName + "'>"
		+ "<option value='compareDate' selected='selected'>日付昇順</option>"
		+ "<option value='compareDateDesc'>日付降順</option>"
		+ "<option value='compareId'>ID昇順</option>"
		+ "<option value='compareIdDesc'>ID降順</option>"
		+ "<option value='compareScore'>得点昇順</option>"
		+ "<option value='compareScoreDesc'>得点降順</option>"
		+ "<option value='compareInterval'>音程昇順</option>"
		+ "<option value='compareIntervalDesc'>音程降順</option>"
		+ "</select>";
	return str;
}