/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.damstation_dl.data;

import jp.sourceforge.damstation_dl.data.SongId;

public class ResultData {
    private final SongId id;
    private final double score;
    private final byte vibratoType;
    private final double vibratoTime;
    private final short shakuri;
    private final byte interval;
    private final byte rhythm;
    private final byte modulation;

    public ResultData(SongId id, double score, int vibratoType, double vibratoTime, int shakuri, int interval, int rhythm, int modulation) {
        if (id == null) {
            throw new NullPointerException("ResultData.ResultData\n\tid=" + id);
        }
        if (!ResultData.isValidScore(score)) {
            throw new IllegalArgumentException("ResultData.ResultData score is invalid.\n\tscore=" + score);
        }
        if (!ResultData.isValidVibratoType(vibratoType)) {
            throw new IllegalArgumentException("ResultData.ResultData vibratoType is invalid.\n\tvibratoType=" + vibratoType);
        }
        if (!ResultData.isValidVibratoTime(vibratoTime)) {
            throw new IllegalArgumentException("ResultData.ResultData vibratoTime is invalid.\n\tvibratoTime=" + vibratoTime);
        }
        if (!ResultData.isValidShakuri(shakuri)) {
            throw new IllegalArgumentException("ResultData.ResultData shakuri is invalid.\n\tshakuri=" + shakuri);
        }
        if (!ResultData.isValidInterval(interval)) {
            throw new IllegalArgumentException("ResultData.ResultData interval is invalid.\n\tinterval=" + interval);
        }
        if (!ResultData.isValidRhythm(rhythm)) {
            throw new IllegalArgumentException("ResultData.ResultData rhythm is invalid.\n\trhythm=" + rhythm);
        }
        if (!ResultData.isValidModulation(modulation)) {
            throw new IllegalArgumentException("ResultData.ResultData modulation is invalid.\n\tmodulation=" + modulation);
        }
        this.id = id;
        this.score = score;
        this.vibratoType = (byte)vibratoType;
        this.vibratoTime = vibratoTime;
        this.shakuri = (short)shakuri;
        this.interval = (byte)interval;
        this.rhythm = (byte)rhythm;
        this.modulation = (byte)modulation;
    }

    public SongId getId() {
        return this.id;
    }

    public byte getInterval() {
        return this.interval;
    }

    public byte getModulation() {
        return this.modulation;
    }

    public byte getRhythm() {
        return this.rhythm;
    }

    public double getScore() {
        return this.score;
    }

    public short getShakuri() {
        return this.shakuri;
    }

    public double getVibratoTime() {
        return this.vibratoTime;
    }

    public byte getVibratoType() {
        return this.vibratoType;
    }

    public static boolean isValidScore(double score) {
        return !(score < 0.0) && !(score > 100.0);
    }

    public static boolean isValidInterval(int interval) {
        return interval >= 0 && interval <= 100;
    }

    public static boolean isValidVibratoTime(double vibratoTime) {
        return !(vibratoTime < 0.0);
    }

    public static boolean isValidVibratoType(int vibratoType) {
        return vibratoType >= 0 && vibratoType <= 9;
    }

    public static boolean isValidRhythm(int rhythm) {
        return rhythm >= -3 && rhythm <= 3;
    }

    public static boolean isValidShakuri(int shakuri) {
        return shakuri >= 0 && shakuri <= Short.MAX_VALUE;
    }

    public static boolean isValidModulation(int modulation) {
        return modulation >= 0 && modulation <= 10;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{id=");
        buffer.append(this.id);
        buffer.append(", score=");
        buffer.append(this.score);
        buffer.append(", vibratoType=");
        buffer.append(this.vibratoType);
        buffer.append(", vibratoTime=");
        buffer.append(this.vibratoTime);
        buffer.append(", shakuri=");
        buffer.append(this.shakuri);
        buffer.append(", interval=");
        buffer.append(this.interval);
        buffer.append(", rhythm=");
        buffer.append(this.rhythm);
        buffer.append(", modulation=");
        buffer.append(this.modulation);
        buffer.append("}");
        return buffer.toString();
    }
}

