/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.damstation_dl.data;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomUtility {
    private DomUtility() {
    }

    public static Element getRootElementByTagName(Document dom, String tagName) {
        if (dom == null || tagName == null) {
            throw new NullPointerException("DomUtility.getRootElementByTagName\n\tdom=" + dom + "\n\ttagName=" + tagName);
        }
        Element root = dom.getDocumentElement();
        if (!tagName.equals(root.getNodeName())) {
            throw new IllegalStateException("DomUtility.getRootElementByTagName\n\tdom=" + dom + "\n\ttagName=" + tagName + "\n\troot=" + root);
        }
        return root;
    }

    public static String getSingleTextContentByTagName(Element element, String tagName) {
        if (element == null || tagName == null) {
            throw new NullPointerException("DomUtility.getSingleTextContentByTagName\n\telement=" + element + "\n\ttagName=" + tagName);
        }
        if (tagName.isEmpty()) {
            throw new IllegalArgumentException("DomUtility.getSingleTextContentByTagName\n\telement=" + element + "\n\ttagName=" + tagName);
        }
        NodeList elements = element.getElementsByTagName(tagName);
        if (elements.getLength() != 1) {
            throw new IllegalStateException("DomUtility.getSingleTextContentByTagName\n\telement=" + element + "\n\ttagName=" + tagName + "\n\telements.getLength()=" + elements.getLength());
        }
        NodeList textNodes = elements.item(0).getChildNodes();
        switch (textNodes.getLength()) {
            case 0: {
                return "";
            }
            case 1: {
                Node textNode = textNodes.item(0);
                if (3 != textNode.getNodeType()) {
                    throw new IllegalStateException("DomUtility.getSingleTextContentByTagName\n\telement=" + element + "\n\ttagName=" + tagName + "\n\ttextNode.getNodeType()=" + textNode.getNodeType());
                }
                return textNode.getNodeValue();
            }
        }
        throw new IllegalStateException("DomUtility.getSingleTextContentByTagName\n\telement=" + element + "\n\ttagName=" + tagName + "\n\ttextNodes.getLength()=" + textNodes.getLength());
    }

    public static String getAttribute(Element element, String attributeName) {
        if (element == null || attributeName == null) {
            throw new NullPointerException("DomUtility.getAttribute\n\telement=" + element + "\n\tattributeName=" + attributeName);
        }
        if (attributeName.isEmpty()) {
            throw new IllegalArgumentException("DomUtility.getAttribute\n\telement=" + element + "\n\tattributeName=" + attributeName);
        }
        String value = element.getAttribute(attributeName);
        if (value.isEmpty()) {
            throw new IllegalStateException("DomUtility.getAttribute\n\telement=" + element + "\n\tattributeName=" + attributeName + "\n\tvalue=" + value);
        }
        return value;
    }

    public static String toElementString(String tagName, String textContent) {
        if (tagName == null) {
            throw new NullPointerException("DomUtility.toElementString\n\ttagName=" + tagName + "\n\ttextContent=" + textContent);
        }
        if (tagName.isEmpty()) {
            throw new IllegalArgumentException("DomUtility.toElementString\n\ttagName=" + tagName + "\n\ttextContent=" + textContent);
        }
        if (textContent.isEmpty()) {
            textContent = "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<");
        buffer.append(tagName);
        buffer.append(">");
        buffer.append(textContent);
        buffer.append("</");
        buffer.append(tagName);
        buffer.append(">");
        return buffer.toString();
    }

    public static String escapeXmlEntityCharacter(String str) {
        if (str == null) {
            throw new NullPointerException();
        }
        if (str.isEmpty()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        block7: for (int pos = 0; pos < str.length(); ++pos) {
            switch (str.charAt(pos)) {
                case '<': {
                    buffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    buffer.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    buffer.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    buffer.append("&apos;");
                    continue block7;
                }
                case '&': {
                    buffer.append("&amp;");
                    continue block7;
                }
                default: {
                    buffer.append(str.charAt(pos));
                }
            }
        }
        return buffer.toString();
    }
}

