/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.damstation_dl;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import jp.sourceforge.damstation_dl.DownloadThread;
import jp.sourceforge.damstation_dl.TodoData;
import jp.sourceforge.damstation_dl.data.ConfigData;
import jp.sourceforge.damstation_dl.data.PasswordUtility;
import jp.sourceforge.damstation_dl.data.ResultData2List;
import jp.sourceforge.damstation_dl.data.ResultDataList;
import jp.sourceforge.damstation_dl.data.SongDataList;

public class MainWindow
extends JFrame {
    private final ConfigData configData;
    private final SongDataList songData;
    private final ResultDataList resultData;
    private final ResultData2List resultData2;
    private DownloadThread thread = null;
    private JTextField jCardNumberField;
    private JLabel jCardNumberLabel;
    private JPanel jConfigPanel;
    private JPasswordField jPasswordField;
    private JLabel jPasswordLabel;
    private JScrollPane jScrollPane1;
    private JButton jStartButton;
    private JButton jStopButton;
    private JTextArea jTextArea;
    private JCheckBox jTodoFixSongDataCheckBox;
    private JPanel jTodoPanel;
    private JCheckBox jTodoSeimitsu2CheckBox;
    private JCheckBox jTodoSeimitsuCheckBox;

    public MainWindow() {
        this.initComponents();
        CookieManager cookieManager = new CookieManager();
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        CookieHandler.setDefault(cookieManager);
        this.configData = new ConfigData("config.xml");
        this.songData = new SongDataList("data/songs.xml");
        this.resultData = new ResultDataList("data/results.xml");
        this.resultData2 = new ResultData2List("data/results2.xml");
        this.setFieldValue();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea = new JTextArea();
        this.jTodoPanel = new JPanel();
        this.jTodoSeimitsuCheckBox = new JCheckBox();
        this.jTodoSeimitsu2CheckBox = new JCheckBox();
        this.jTodoFixSongDataCheckBox = new JCheckBox();
        this.jConfigPanel = new JPanel();
        this.jStartButton = new JButton();
        this.jStopButton = new JButton();
        this.jCardNumberLabel = new JLabel();
        this.jPasswordLabel = new JLabel();
        this.jCardNumberField = new JTextField();
        this.jPasswordField = new JPasswordField();
        this.setDefaultCloseOperation(0);
        this.setTitle("DAM\u30b9\u30c6\u30fc\u30b7\u30e7\u30f3\u30c0\u30a6\u30f3\u30ed\u30fc\u30c0 ver0.6.3");
        this.setResizable(false);
        this.jTextArea.setColumns(20);
        this.jTextArea.setRows(5);
        this.jTextArea.setBorder(null);
        this.jTextArea.setMargin(new Insets(0, 0, 0, 0));
        this.jScrollPane1.setViewportView(this.jTextArea);
        this.jTodoPanel.setBackground(new Color(255, 255, 255));
        this.jTodoPanel.setBorder(BorderFactory.createTitledBorder("TODO"));
        this.jTodoSeimitsuCheckBox.setBackground(Color.white);
        this.jTodoSeimitsuCheckBox.setText("\u7cbe\u5bc6\u63a1\u70b9");
        this.jTodoSeimitsuCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.jTodoSeimitsuCheckBoxActionPerformed(evt);
            }
        });
        this.jTodoSeimitsu2CheckBox.setBackground(Color.white);
        this.jTodoSeimitsu2CheckBox.setText("\u7cbe\u5bc6\u63a1\u70b9II");
        this.jTodoFixSongDataCheckBox.setBackground(Color.gray);
        this.jTodoFixSongDataCheckBox.setText("\u66f2\u30c7\u30fc\u30bf\u4fee\u6b63");
        this.jTodoFixSongDataCheckBox.setEnabled(false);
        GroupLayout jTodoPanelLayout = new GroupLayout(this.jTodoPanel);
        this.jTodoPanel.setLayout(jTodoPanelLayout);
        jTodoPanelLayout.setHorizontalGroup(jTodoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jTodoPanelLayout.createSequentialGroup().addContainerGap().addGroup(jTodoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTodoSeimitsuCheckBox).addComponent(this.jTodoSeimitsu2CheckBox).addComponent(this.jTodoFixSongDataCheckBox)).addContainerGap(46, Short.MAX_VALUE)));
        jTodoPanelLayout.setVerticalGroup(jTodoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jTodoPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jTodoSeimitsuCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTodoSeimitsu2CheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTodoFixSongDataCheckBox).addContainerGap(28, Short.MAX_VALUE)));
        this.jConfigPanel.setBackground(new Color(255, 255, 255));
        this.jConfigPanel.setBorder(BorderFactory.createTitledBorder("\u8a2d\u5b9a"));
        this.jStartButton.setText("\u958b\u59cb");
        this.jStartButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.jStartButtonActionPerformed(evt);
            }
        });
        this.jStopButton.setText("\u4e2d\u6b62");
        this.jStopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.jStopButtonActionPerformed(evt);
            }
        });
        this.jCardNumberLabel.setText("\u30ab\u30fc\u30c9\u756a\u53f7");
        this.jPasswordLabel.setText("\u30d1\u30b9\u30ef\u30fc\u30c9");
        this.jCardNumberField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.jCardNumberFieldActionPerformed(evt);
            }
        });
        GroupLayout jConfigPanelLayout = new GroupLayout(this.jConfigPanel);
        this.jConfigPanel.setLayout(jConfigPanelLayout);
        jConfigPanelLayout.setHorizontalGroup(jConfigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jConfigPanelLayout.createSequentialGroup().addGroup(jConfigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jConfigPanelLayout.createSequentialGroup().addGap(44, 44, 44).addComponent(this.jStartButton).addGap(40, 40, 40).addComponent(this.jStopButton)).addGroup(jConfigPanelLayout.createSequentialGroup().addContainerGap().addGroup(jConfigPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jCardNumberLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPasswordLabel, GroupLayout.Alignment.LEADING, -1, 54, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jConfigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jCardNumberField).addComponent(this.jPasswordField, -1, 162, Short.MAX_VALUE)))).addContainerGap(-1, Short.MAX_VALUE)));
        jConfigPanelLayout.setVerticalGroup(jConfigPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jConfigPanelLayout.createSequentialGroup().addContainerGap().addGroup(jConfigPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCardNumberLabel).addComponent(this.jCardNumberField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jConfigPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jPasswordField, -2, -1, -2).addComponent(this.jPasswordLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jConfigPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jStartButton).addComponent(this.jStopButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 430, -2).addGroup(layout.createSequentialGroup().addComponent(this.jConfigPanel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jTodoPanel, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTodoPanel, -1, -1, Short.MAX_VALUE).addComponent(this.jConfigPanel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 193, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void jStartButtonActionPerformed(ActionEvent evt) {
        if (this.thread == null || this.thread.isDone()) {
            this.getFieldValue();
            TodoData todoData = new TodoData(this.jTodoSeimitsuCheckBox.isSelected(), this.jTodoSeimitsu2CheckBox.isSelected());
            this.thread = new DownloadThread(this.jStartButton, this.jTextArea, this.configData, this.songData, this.resultData, this.resultData2, todoData);
            this.thread.execute();
        }
    }

    private void jStopButtonActionPerformed(ActionEvent evt) {
        if (this.thread != null && !this.thread.isDone()) {
            this.thread.cancel(true);
        }
    }

    private void jCardNumberFieldActionPerformed(ActionEvent evt) {
    }

    private void jTodoSeimitsuCheckBoxActionPerformed(ActionEvent evt) {
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                MainWindow frame = new MainWindow();
                frame.init();
                frame.setVisible(true);
            }
        });
    }

    private void init() {
        this.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void windowClosing(WindowEvent event) {
                if (MainWindow.this.thread != null && !MainWindow.this.thread.isDone()) {
                    return;
                }
                Object object = MainWindow.this.configData;
                synchronized (object) {
                    MainWindow.this.getFieldValue();
                    if (MainWindow.this.configData != null) {
                        try {
                            MainWindow.this.configData.writeXml("config.xml");
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }
                object = MainWindow.this.songData;
                synchronized (object) {
                    if (MainWindow.this.songData != null) {
                        try {
                            MainWindow.this.songData.writeXml("data/songs.xml");
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }
                object = MainWindow.this.resultData;
                synchronized (object) {
                    if (MainWindow.this.resultData != null) {
                        try {
                            MainWindow.this.resultData.writeXml("data/results.xml");
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }
                object = MainWindow.this.resultData2;
                synchronized (object) {
                    if (MainWindow.this.resultData2 != null) {
                        try {
                            MainWindow.this.resultData2.writeXml("data/results2.xml");
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                MainWindow.this.dispose();
            }
        });
    }

    private void setFieldValue() {
        this.jCardNumberField.setText(this.configData.getCardNumber());
        this.jPasswordField.setText(PasswordUtility.decode(this.configData.getPassword()));
    }

    private void getFieldValue() {
        this.configData.setCardNumber(this.jCardNumberField.getText());
        this.configData.setPassword(PasswordUtility.encode(new String(this.jPasswordField.getPassword())));
    }
}

