/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.damstation_dl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import jp.sourceforge.damstation_dl.LoginPageParser;
import jp.sourceforge.damstation_dl.Seimitsu2PageParser;
import jp.sourceforge.damstation_dl.SeimitsuPageParser;
import jp.sourceforge.damstation_dl.TextDownloader;
import jp.sourceforge.damstation_dl.TodoData;
import jp.sourceforge.damstation_dl.data.ConfigData;
import jp.sourceforge.damstation_dl.data.PasswordUtility;
import jp.sourceforge.damstation_dl.data.ResultData;
import jp.sourceforge.damstation_dl.data.ResultData2;
import jp.sourceforge.damstation_dl.data.ResultData2List;
import jp.sourceforge.damstation_dl.data.ResultDataList;
import jp.sourceforge.damstation_dl.data.ResultDate;
import jp.sourceforge.damstation_dl.data.SongData;
import jp.sourceforge.damstation_dl.data.SongDataList;
import jp.sourceforge.damstation_dl.data.SongId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadThread
extends SwingWorker<Object, String> {
    private final JButton button;
    private final JTextArea textArea;
    private ConfigData configData;
    private final SongDataList songData;
    private final ResultDataList resultData;
    private final ResultData2List resultData2;
    private final TodoData todoData;

    public DownloadThread(JButton button, JTextArea textArea, ConfigData configData, SongDataList songData, ResultDataList resultData, ResultData2List resultData2, TodoData todoData) {
        if (button == null || textArea == null || configData == null || songData == null || resultData == null || resultData2 == null) {
            throw new NullPointerException("DownloadThread.DownloadThread");
        }
        this.button = button;
        this.textArea = textArea;
        this.configData = configData;
        this.songData = songData;
        this.resultData = resultData;
        this.resultData2 = resultData2;
        this.todoData = todoData;
        button.setEnabled(false);
    }

    @Override
    public Object doInBackground() throws Exception {
        if (this.isCancelled()) {
            this.publish("\u30a8\u30e9\u30fc\uff1a\u51e6\u7406\u3092\u4e2d\u65ad\u3057\u307e\u3057\u305f\u3002\n");
            return null;
        }
        if (this.configData.getCardNumber().isEmpty()) {
            this.publish("\u30a8\u30e9\u30fc\uff1a\u30ab\u30fc\u30c9\u756a\u53f7\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n");
            this.publish("\u30a8\u30e9\u30fc\uff1a\u51e6\u7406\u3092\u4e2d\u65ad\u3057\u307e\u3057\u305f\u3002\n");
            return null;
        }
        if (PasswordUtility.decode(this.configData.getPassword()).isEmpty()) {
            this.publish("\u30a8\u30e9\u30fc\uff1a\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n");
            this.publish("\u30a8\u30e9\u30fc\uff1a\u51e6\u7406\u3092\u4e2d\u65ad\u3057\u307e\u3057\u305f\u3002\n");
            return null;
        }
        this.publish("\u51e6\u7406\u3092\u958b\u59cb\u3057\u307e\u3059\u3002\n");
        try {
            int page;
            TextDownloader downloader = new TextDownloader(this.configData.getConnectTimeout(), this.configData.getReadTimeout(), this.configData.getProxy());
            this.publish("\u30ed\u30b0\u30a4\u30f3\u30da\u30fc\u30b8\u306b\u63a5\u7d9a\u3057\u307e\u3059\u3002\n");
            String source = this.getLoginPageSource(downloader);
            if (this.isCancelled()) {
                this.publish("\u30a8\u30e9\u30fc\uff1a\u51e6\u7406\u3092\u4e2d\u65ad\u3057\u307e\u3057\u305f\u3002\n");
                return null;
            }
            if (!this.isLogin(source)) {
                this.publish("\u30a8\u30e9\u30fc\uff1a\u30ed\u30b0\u30a4\u30f3\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\n");
                this.publish("\u30a8\u30e9\u30fc\uff1a\u51e6\u7406\u3092\u4e2d\u65ad\u3057\u307e\u3057\u305f\u3002\n");
                return null;
            }
            this.publish("\u30ed\u30b0\u30a4\u30f3\u306b\u6210\u529f\u3057\u307e\u3057\u305f\u3002\n");
            if (this.isCancelled()) {
                this.publish("\u30a8\u30e9\u30fc\uff1a\u51e6\u7406\u3092\u4e2d\u65ad\u3057\u307e\u3057\u305f\u3002\n");
                return null;
            }
            if (this.todoData.isDownloadSeimitsu()) {
                for (page = 1; page <= 10; ++page) {
                    this.publish("\u7cbe\u5bc6\u63a1\u70b9\u306e" + page + "\u30da\u30fc\u30b8\u76ee\u306b\u63a5\u7d9a\u3057\u307e\u3059\u3002\n");
                    source = this.getSeimitsuPageSource(downloader, page);
                    if (this.isCancelled()) {
                        this.publish("\u30a8\u30e9\u30fc\uff1a\u51e6\u7406\u3092\u4e2d\u65ad\u3057\u307e\u3057\u305f\u3002\n");
                        return null;
                    }
                    this.updateResultData(source, page);
                    if (!this.isCancelled()) continue;
                    this.publish("\u30a8\u30e9\u30fc\uff1a\u51e6\u7406\u3092\u4e2d\u65ad\u3057\u307e\u3057\u305f\u3002\n");
                    return null;
                }
            }
            if (this.todoData.isDownloadSeimitsu2()) {
                for (page = 1; page <= 10; ++page) {
                    this.publish("\u7cbe\u5bc6\u63a1\u70b9II\u306e" + page + "\u30da\u30fc\u30b8\u76ee\u306b\u63a5\u7d9a\u3057\u307e\u3059\u3002\n");
                    source = this.getSeimitsu2PageSource(downloader, page);
                    if (this.isCancelled()) {
                        this.publish("\u30a8\u30e9\u30fc\uff1a\u51e6\u7406\u3092\u4e2d\u65ad\u3057\u307e\u3057\u305f\u3002\n");
                        return null;
                    }
                    this.updateResultData2(source, page);
                    if (!this.isCancelled()) continue;
                    this.publish("\u30a8\u30e9\u30fc\uff1a\u51e6\u7406\u3092\u4e2d\u65ad\u3057\u307e\u3057\u305f\u3002\n");
                    return null;
                }
            }
        }
        catch (Exception e) {
            this.publish("\u30a8\u30e9\u30fc\uff1a\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\n");
            this.publish(e.toString() + "\n");
            this.publish("\u30a8\u30e9\u30fc\uff1a\u51e6\u7406\u3092\u4e2d\u65ad\u3057\u307e\u3057\u305f\u3002\n");
            return null;
        }
        this.publish("\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002\n");
        return null;
    }

    @Override
    protected void process(List<String> chunks) {
        for (String message : chunks) {
            if (this.isCancelled()) continue;
            this.textArea.append(message);
        }
    }

    @Override
    protected void done() {
        if (this.isCancelled()) {
            this.textArea.append("\u30a8\u30e9\u30fc\uff1a\u51e6\u7406\u3092\u4e2d\u65ad\u3057\u307e\u3057\u305f\u3002\n");
        }
        this.button.setEnabled(true);
    }

    public String getLoginPageSource(TextDownloader downloader) throws IOException {
        HashMap<String, String> loginPostValues = new HashMap<String, String>();
        loginPostValues.put("cardNumber", this.configData.getCardNumber());
        loginPostValues.put("password", PasswordUtility.decode(this.configData.getPassword()));
        return downloader.download("https://www.clubdam.com/app/auth/memMemberLogin.do", loginPostValues);
    }

    public boolean isLogin(String source) throws IOException {
        HashMap<String, String> loginPostValues = new HashMap<String, String>();
        loginPostValues.put("cardNumber", this.configData.getCardNumber());
        loginPostValues.put("password", PasswordUtility.decode(this.configData.getPassword()));
        return new LoginPageParser(new BufferedReader(new StringReader(source))).isLogin();
    }

    public String getSeimitsuPageSource(TextDownloader downloader, int page) throws IOException {
        return downloader.download("https://www.clubdam.com/app/membership/marking/listUp.do?page=" + page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateResultData(String source, int page) throws IOException {
        SeimitsuPageParser parser = new SeimitsuPageParser(new BufferedReader(new StringReader(source)));
        Map<SongId, SongData> dlSongDataList = parser.getSongDataList();
        int updateSongDataCount = 0;
        SongDataList songDataList = this.songData;
        synchronized (songDataList) {
            for (Map.Entry<SongId, SongData> entry : dlSongDataList.entrySet()) {
                if (this.songData.hasSongData(entry.getKey())) continue;
                this.songData.add(entry.getKey(), entry.getValue());
                ++updateSongDataCount;
            }
        }
        this.publish("\u66f2\u30c7\u30fc\u30bf\u306b" + updateSongDataCount + "/" + dlSongDataList.size() + "\u4ef6\u8ffd\u52a0\u3057\u307e\u3057\u305f\u3002\n");
        Map<ResultDate, ResultData> dlResultDataList = parser.getResultDataList();
        int updateResultDataCount = 0;
        ResultDataList resultDataList = this.resultData;
        synchronized (resultDataList) {
            for (Map.Entry<ResultDate, ResultData> entry : dlResultDataList.entrySet()) {
                if (this.resultData.hasResultData(entry.getKey())) continue;
                this.resultData.add(entry.getKey(), entry.getValue());
                ++updateResultDataCount;
            }
        }
        this.publish("\u7d50\u679c\u30c7\u30fc\u30bf\u306b" + updateResultDataCount + "/" + dlResultDataList.size() + "\u4ef6\u8ffd\u52a0\u3057\u307e\u3057\u305f\u3002\n");
    }

    public String getSeimitsu2PageSource(TextDownloader downloader, int page) throws IOException {
        return downloader.download("https://www.clubdam.com/app/membership/marking/listUpMarkingTwo.do?page=" + page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateResultData2(String source, int page) throws IOException {
        Seimitsu2PageParser parser = new Seimitsu2PageParser(new BufferedReader(new StringReader(source)));
        Map<SongId, SongData> dlSongDataList = parser.getSongDataList();
        int updateSongDataCount = 0;
        SongDataList songDataList = this.songData;
        synchronized (songDataList) {
            for (Map.Entry<SongId, SongData> entry : dlSongDataList.entrySet()) {
                if (this.songData.hasSongData(entry.getKey())) continue;
                this.songData.add(entry.getKey(), entry.getValue());
                ++updateSongDataCount;
            }
        }
        this.publish("\u66f2\u30c7\u30fc\u30bf\u306b" + updateSongDataCount + "/" + dlSongDataList.size() + "\u4ef6\u8ffd\u52a0\u3057\u307e\u3057\u305f\u3002\n");
        Map<ResultDate, ResultData2> dlResultData2List = parser.getResultData2List();
        int updateResultData2Count = 0;
        ResultData2List resultData2List = this.resultData2;
        synchronized (resultData2List) {
            for (Map.Entry<ResultDate, ResultData2> entry : dlResultData2List.entrySet()) {
                if (this.resultData2.hasResultData(entry.getKey())) continue;
                this.resultData2.add(entry.getKey(), entry.getValue());
                ++updateResultData2Count;
            }
        }
        this.publish("\u7d50\u679c\u30c7\u30fc\u30bf\u306b" + updateResultData2Count + "/" + dlResultData2List.size() + "\u4ef6\u8ffd\u52a0\u3057\u307e\u3057\u305f\u3002\n");
    }
}

