/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.damstation_dl.data;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Utility {
    private Utility() {
    }

    public static Element getRootElementByTagName(Document dom, String tagName) {
        if (dom == null || tagName == null) {
            throw new NullPointerException("Utility.getRootElementByTagName\n\tdom: " + dom.toString() + "\n\ttagName: " + tagName);
        }
        Element root = dom.getDocumentElement();
        if (!tagName.equals(root.getNodeName())) {
            throw new IllegalStateException("Utility.getRootElementByTagName\n\tdom: " + dom.toString() + "\n\ttagName: " + tagName + "\n\troot.getNodeName(): " + root.getNodeName());
        }
        return root;
    }

    public static String getSingleTextContentByTagName(Element element, String tagName) {
        if (element == null || tagName == null) {
            throw new NullPointerException("Utility.getSingleElementValueByTagName\n\telement: " + element.toString() + "\n\ttagName: " + tagName);
        }
        NodeList list = element.getElementsByTagName(tagName);
        if (list.getLength() != 1) {
            throw new IllegalStateException("Utility.getSingleElementValueByTagName\n\telement: " + element.toString() + "\n\ttagName: " + tagName + "\n\tlist.getLength(): " + list.getLength());
        }
        NodeList childList = list.item(0).getChildNodes();
        if (list.getLength() != 1) {
            throw new IllegalStateException("Utility.getSingleElementValueByTagName\n\telement: " + element.toString() + "\n\ttagName: " + tagName + "\n\tchildList.getLength(): " + childList.getLength());
        }
        Node textNode = childList.item(0);
        if (textNode.getNodeType() != 3) {
            throw new IllegalStateException("Utility.getSingleElementValueByTagName\n\telement: " + element.toString() + "\n\ttagName: " + tagName + "\n\ttextNode.getNodeType(): " + textNode.getNodeType());
        }
        return textNode.getNodeValue();
    }

    public static String getAttribute(Element element, String attributeName) {
        if (element == null || attributeName == null) {
            throw new NullPointerException("Utility.getAttribute\n\telement: " + element.toString() + "\n\tattributeName: " + attributeName);
        }
        String value = element.getAttribute(attributeName);
        if (value.isEmpty()) {
            throw new IllegalStateException("Utility.getAttribute\n\telement: " + element.toString() + "\n\tattributeName: " + attributeName);
        }
        return value;
    }
}

