/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.damstation_dl.data;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ResultDate {
    private static final int DAM_STATION_DATE_LENGTH = 19;
    private static final int XML_DATE_LENGTH = 19;
    private static final DateFormat DAM_STATION_DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", Locale.JAPANESE);
    private static final DateFormat XML_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.JAPANESE);
    private static final Map<String, ResultDate> map = new HashMap<String, ResultDate>();
    private String value;

    private ResultDate(String date) {
        if (date == null) {
            throw new NullPointerException("ResultDate.ResultDate\n\tdate=" + date);
        }
        if (!ResultDate.isValid(date)) {
            throw new IllegalArgumentException("ResultDate.ResultDate\n\tdate=" + date);
        }
        this.value = date;
    }

    public static ResultDate getInstance(String date) {
        if (map.containsKey(date)) {
            return map.get(date);
        }
        ResultDate instance = new ResultDate(date);
        map.put(date, instance);
        return instance;
    }

    public static boolean isValid(String xmlDateString) {
        if (xmlDateString == null) {
            throw new NullPointerException("ResultData.isValidDate\n\txmlDateString=" + xmlDateString);
        }
        if (xmlDateString.length() != 19) {
            return false;
        }
        Date date = null;
        try {
            date = XML_DATE_FORMAT.parse(xmlDateString);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    public static String damStationDateToXmlDateTime(String damStationDateString) throws ParseException {
        if (damStationDateString == null) {
            throw new NullPointerException("ResultDate.damStationDateToXmlDateTime\n\tdamStationDateString=" + damStationDateString);
        }
        if (damStationDateString.length() < 19) {
            throw new ParseException("ResultDate.damStationDateToXmlDateTime too short string.\n\tdamStationDateString=" + damStationDateString, damStationDateString.length());
        }
        if (damStationDateString.length() > 19) {
            throw new ParseException("ResultDate.damStationDateToXmlDateTime too long string.\n\tdamStationDateString=" + damStationDateString, 20);
        }
        Date date = null;
        date = DAM_STATION_DATE_FORMAT.parse(damStationDateString);
        return XML_DATE_FORMAT.format(date);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    static {
        DAM_STATION_DATE_FORMAT.setLenient(false);
        XML_DATE_FORMAT.setLenient(false);
    }
}

