/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.damstation_dl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.damstation_dl.data.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextDownloader {
    private final int connectTimeout;
    private final int readTimeout;
    private final java.net.Proxy proxy;

    public TextDownloader(int connectTimeout, int readTimeout, Proxy proxy) {
        if (connectTimeout < 0 || readTimeout < 0) {
            throw new IllegalArgumentException("TextDownloader.TextDownloader\n\tconnectTimeout: " + connectTimeout + "\n\treadTimeout: " + readTimeout);
        }
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.proxy = proxy == null ? java.net.Proxy.NO_PROXY : new java.net.Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxy.getHost(), proxy.getPort()));
    }

    public String download(String urlString) throws IOException {
        return this.download(urlString, null);
    }

    public String download(String urlString, Map<String, String> postValues) throws IOException {
        URLConnection conn;
        if (urlString == null) {
            throw new NullPointerException("TextDownloader.download");
        }
        try {
            conn = new URL(urlString).openConnection(this.proxy);
        }
        catch (MalformedURLException e) {
            throw new IOException("TextDownloader.download\n\turlString=" + urlString + "\n\te=" + e.toString());
        }
        catch (IOException e) {
            throw new IOException("TextDownloader.download\n\turlString=" + urlString + "\n\te=" + e.toString());
        }
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setConnectTimeout(this.connectTimeout);
        conn.setReadTimeout(this.readTimeout);
        if (postValues != null) {
            PrintWriter pw = null;
            try {
                pw = new PrintWriter(conn.getOutputStream());
                pw.print(TextDownloader.postValuesToString(postValues));
            }
            catch (IOException e) {
                throw new IOException("TextDownloader.download\n\turlString=" + urlString + "\n\tpostValues=" + postValues.toString() + "\n\te=" + e.toString());
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
            }
        }
        try {
            conn.connect();
        }
        catch (SocketTimeoutException e) {
            throw new IOException("TextDownloader.download\n\te=" + e.toString());
        }
        catch (IOException e) {
            throw e;
        }
        return TextDownloader.inputStreamToString(conn.getInputStream());
    }

    private static String inputStreamToString(InputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("TextDownloader.inputStreamToString");
        }
        BufferedReader reader = null;
        StringBuffer text = new StringBuffer();
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(stream));
            while ((line = reader.readLine()) != null) {
                text.append(line);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
        }
        return text.toString();
    }

    public static String postValuesToString(Map<String, String> postValues) {
        if (postValues == null) {
            throw new NullPointerException("TextDonwloader.postValuesToString");
        }
        StringBuffer postValuesString = new StringBuffer();
        Set<String> keys = postValues.keySet();
        Iterator<String> iterator = keys.iterator();
        boolean isNotFirst = false;
        while (iterator.hasNext()) {
            if (isNotFirst) {
                postValuesString.append("&");
            } else {
                isNotFirst = true;
            }
            String key = iterator.next();
            if (key == null || postValues.get(key) == null) {
                throw new NullPointerException("TextDonwloader.postValuesToString\n\tkey: " + key + "\n\tvalue: " + postValues.get(key));
            }
            if (key.isEmpty() || postValues.get(key).isEmpty()) {
                throw new IllegalArgumentException("TextDonwloader.postValuesToString\n\tkey: " + key + "\n\tvalue: " + postValues.get(key));
            }
            postValuesString.append(key + "=" + postValues.get(key));
        }
        return postValuesString.toString();
    }
}

