/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.damstation_dl;

import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import jp.sourceforge.damstation_dl.data.ResultData;
import jp.sourceforge.damstation_dl.data.ResultDate;
import jp.sourceforge.damstation_dl.data.SongData;
import jp.sourceforge.damstation_dl.data.SongId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeimitsuPageParser {
    private static final int TD_ELEMENT_COUNT = 23;
    private static final Pattern DATE_PATTERN = Pattern.compile("\\d{4}/\\d{2}/\\d{2} \\d{2}:\\d{2}:\\d{2}");
    private static final Pattern FILENAME_PATTERN = Pattern.compile("/(.)+?[.]gif$");
    private static final Pattern VIBRATO_TIME_PATTERN = Pattern.compile("^[0-9.]+");
    private static final String SEARCH_CLASSNAME = new String("list_marking");
    private Map<SongId, SongData> songDataList = new HashMap<SongId, SongData>();
    private Map<ResultDate, ResultData> resultDataList = new HashMap<ResultDate, ResultData>();

    public static int parseVibratoTypeInteger(String vibratoType) {
        if ("\u7121\u3057".equals(vibratoType)) {
            return 0;
        }
        if ("A-1".equals(vibratoType)) {
            return 1;
        }
        if ("A-2".equals(vibratoType)) {
            return 2;
        }
        if ("A-3".equals(vibratoType)) {
            return 3;
        }
        if ("B-1".equals(vibratoType)) {
            return 4;
        }
        if ("B-2".equals(vibratoType)) {
            return 5;
        }
        if ("B-3".equals(vibratoType)) {
            return 6;
        }
        if ("C-1".equals(vibratoType)) {
            return 7;
        }
        if ("C-2".equals(vibratoType)) {
            return 8;
        }
        if ("C-3".equals(vibratoType)) {
            return 9;
        }
        return -1;
    }

    public SeimitsuPageParser(Reader reader) throws IOException {
        ParserDelegator parserDelegator = new ParserDelegator();
        SeimitsuPageParserCallback parserCallback = new SeimitsuPageParserCallback();
        parserDelegator.parse(reader, parserCallback, true);
    }

    public Map<SongId, SongData> getSongDataList() {
        return this.songDataList;
    }

    public Map<ResultDate, ResultData> getResultDataList() {
        return this.resultDataList;
    }

    private class SeimitsuPageParserCallback
    extends HTMLEditorKit.ParserCallback {
        private Matcher matcher = null;
        private int imgCount = 0;
        private int tdCount = 0;
        private int textCount = 0;
        private boolean isTitle = false;
        private boolean isArtist = false;
        private boolean isChecking = false;
        private String id;
        private String title;
        private String artist;
        private String date;
        private String score;
        private String vibratoType;
        private String vibratoTime;
        private String shakuri;
        private String interval;
        private String rhythm;
        private String modulation;

        private SeimitsuPageParserCallback() {
        }

        public void handleEndOfLineString(String eol) {
            super.handleEndOfLineString(eol);
            this.matcher = null;
        }

        public void handleEndTag(HTML.Tag t, int pos) {
            super.handleEndTag(t, pos);
            if (!this.isChecking) {
                return;
            }
            if (HTML.Tag.TABLE.equals(t)) {
                this.endCheck();
            } else if (HTML.Tag.A.equals(t) && this.isTitle) {
                this.isTitle = false;
            } else if (HTML.Tag.P.equals(t) && this.isArtist) {
                this.isArtist = false;
            } else if (HTML.Tag.TD.equals(t)) {
                this.textCount = 0;
            }
        }

        public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            super.handleSimpleTag(t, a, pos);
            if (!this.isChecking) {
                return;
            }
            if (HTML.Tag.IMG.equals(t)) {
                ++this.imgCount;
                switch (this.imgCount) {
                    case 1: {
                        this.matcher = FILENAME_PATTERN.matcher((String)a.getAttribute(HTML.Attribute.SRC));
                        if (!this.matcher.find() || this.matcher.groupCount() < 1) break;
                        this.rhythm = this.matcher.group(1);
                        break;
                    }
                    case 2: {
                        this.matcher = FILENAME_PATTERN.matcher((String)a.getAttribute(HTML.Attribute.SRC));
                        if (!this.matcher.find() || this.matcher.groupCount() < 1) break;
                        this.modulation = this.matcher.group(1);
                        break;
                    }
                }
            }
        }

        public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            super.handleStartTag(t, a, pos);
            if (HTML.Tag.TABLE.equals(t) && SEARCH_CLASSNAME.equals(a.getAttribute(HTML.Attribute.CLASS))) {
                this.startCheck();
            }
            if (this.isChecking) {
                if (HTML.Tag.TD.equals(t)) {
                    ++this.tdCount;
                } else if (HTML.Tag.A.equals(t) && this.tdCount == 2) {
                    this.isTitle = true;
                } else if (HTML.Tag.P.equals(t) && this.tdCount == 2) {
                    this.isArtist = true;
                }
            }
        }

        public void handleText(char[] data, int pos) {
            super.handleText(data, pos);
            if (!this.isChecking) {
                return;
            }
            ++this.textCount;
            switch (this.tdCount) {
                case 1: {
                    this.matcher = DATE_PATTERN.matcher(new String(data));
                    if (!this.matcher.find()) break;
                    try {
                        this.date = ResultDate.damStationDateToXmlDateTime(this.matcher.group(0));
                    }
                    catch (ParseException e) {
                        this.date = null;
                    }
                    break;
                }
                case 2: {
                    if (this.isTitle) {
                        this.title = new String(data);
                        break;
                    }
                    if (this.isArtist) {
                        this.artist = new String(data);
                        break;
                    }
                    this.id = new String(data).replace("(", "").replace(")", "");
                    break;
                }
                case 3: {
                    if (this.textCount != 2) break;
                    this.score = new String(data).replace("\u70b9", "");
                    break;
                }
                case 9: {
                    switch (this.textCount) {
                        case 1: {
                            this.matcher = VIBRATO_TIME_PATTERN.matcher(new String(data));
                            if (!this.matcher.find()) break;
                            this.vibratoTime = this.matcher.group(0);
                            break;
                        }
                        case 2: {
                            this.vibratoType = new String(data);
                        }
                    }
                    break;
                }
                case 10: {
                    this.shakuri = new String(data).replace("\u56de", "");
                    break;
                }
                case 11: {
                    this.interval = new String(data).replace("%", "");
                    break;
                }
            }
        }

        private void startCheck() {
            this.imgCount = 0;
            this.tdCount = 0;
            this.textCount = 0;
            this.isTitle = false;
            this.isArtist = false;
            this.isChecking = true;
            this.id = null;
            this.title = null;
            this.artist = null;
            this.date = null;
            this.score = null;
            this.vibratoType = null;
            this.vibratoTime = null;
            this.shakuri = null;
            this.interval = null;
            this.rhythm = null;
            this.modulation = null;
        }

        private void endCheck() {
            this.isChecking = false;
            if (this.tdCount == 23) {
                if (this.id == null || this.date == null || this.score == null || this.vibratoType == null || this.vibratoTime == null || this.shakuri == null || this.interval == null || this.rhythm == null || this.modulation == null) {
                    return;
                }
                if (!SongId.isValid(this.id) || !ResultDate.isValid(this.date)) {
                    return;
                }
                SongId songId = SongId.getInstance(this.id);
                ResultDate resultDate = ResultDate.getInstance(this.date);
                ResultData resultData = null;
                try {
                    double score = Double.parseDouble(this.score);
                    int vibratoType = SeimitsuPageParser.parseVibratoTypeInteger(this.vibratoType);
                    double vibratoTime = Double.parseDouble(this.vibratoTime);
                    int shakuri = Integer.parseInt(this.shakuri);
                    int interval = Integer.parseInt(this.interval);
                    int rhythm = Integer.parseInt(this.rhythm);
                    int modulation = Integer.parseInt(this.modulation);
                    if (!(ResultData.isValidScore(score) && ResultData.isValidVibratoType(vibratoType) && ResultData.isValidVibratoTime(vibratoTime) && ResultData.isValidShakuri(shakuri) && ResultData.isValidInterval(interval) && ResultData.isValidRhythm(rhythm) && ResultData.isValidModulation(modulation))) {
                        return;
                    }
                    resultData = new ResultData(songId, score, vibratoType, vibratoTime, shakuri, interval, rhythm, modulation);
                }
                catch (NumberFormatException e) {
                    return;
                }
                if (this.title == null) {
                    this.title = "";
                }
                if (this.artist == null) {
                    this.artist = "";
                }
                if (!SeimitsuPageParser.this.songDataList.containsKey(songId)) {
                    SeimitsuPageParser.this.songDataList.put(songId, new SongData(this.title, this.artist));
                }
                if (!SeimitsuPageParser.this.resultDataList.containsKey(resultDate)) {
                    SeimitsuPageParser.this.resultDataList.put(resultDate, resultData);
                }
            }
        }
    }
}

