/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.damstation_dl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import jp.sourceforge.damstation_dl.LoginPageParser;
import jp.sourceforge.damstation_dl.Seimitsu2PageParser;
import jp.sourceforge.damstation_dl.SeimitsuPageParser;
import jp.sourceforge.damstation_dl.TextDownloader;
import jp.sourceforge.damstation_dl.data.ConfigData;
import jp.sourceforge.damstation_dl.data.PasswordUtility;
import jp.sourceforge.damstation_dl.data.ResultData;
import jp.sourceforge.damstation_dl.data.ResultData2;
import jp.sourceforge.damstation_dl.data.ResultData2List;
import jp.sourceforge.damstation_dl.data.ResultDataList;
import jp.sourceforge.damstation_dl.data.ResultDate;
import jp.sourceforge.damstation_dl.data.SongData;
import jp.sourceforge.damstation_dl.data.SongDataList;
import jp.sourceforge.damstation_dl.data.SongId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadThread
extends SwingWorker<Object, Void> {
    private final JButton button;
    private final JTextArea textArea;
    private ConfigData configData;
    private final SongDataList songData;
    private final ResultDataList resultData;
    private final ResultData2List resultData2;

    public DownloadThread(JButton button, JTextArea textArea, ConfigData configData, SongDataList songData, ResultDataList resultData, ResultData2List resultData2) {
        if (button == null || textArea == null || configData == null || songData == null || resultData == null || resultData2 == null) {
            throw new NullPointerException("DownloadThread.DownloadThread");
        }
        this.button = button;
        this.textArea = textArea;
        this.configData = configData;
        this.songData = songData;
        this.resultData = resultData;
        this.resultData2 = resultData2;
        button.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object doInBackground() throws Exception {
        if (this.configData.getCardNumber().isEmpty()) {
            this.textArea.append("\u30ab\u30fc\u30c9\u756a\u53f7\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\n");
            return null;
        }
        if (PasswordUtility.decode(this.configData.getPassword()).isEmpty()) {
            this.textArea.append("\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\n");
            return null;
        }
        this.textArea.append("\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u958b\u59cb\n");
        try {
            int page;
            TextDownloader downloader = new TextDownloader(this.configData.getConnectTimeout(), this.configData.getReadTimeout(), this.configData.getProxy());
            boolean isLogin = this.login(downloader);
            if (!isLogin) {
                this.textArea.append("\u30ed\u30b0\u30a4\u30f3\u5931\u6557\n");
                Object var3_6 = null;
                return var3_6;
            }
            this.textArea.append("\u30ed\u30b0\u30a4\u30f3\u6210\u529f\n");
            if (this.isCancelled()) {
                Object var3_7 = null;
                return var3_7;
            }
            for (page = 1; page <= 10; ++page) {
                this.updateResultData(downloader, page);
                if (!this.isCancelled()) continue;
                Object var4_11 = null;
                return var4_11;
            }
            page = 1;
            while (page <= 10) {
                this.updateResultData2(downloader, page);
                if (this.isCancelled()) {
                    Object var4_12 = null;
                    return var4_12;
                }
                ++page;
            }
            return null;
        }
        catch (Exception e) {
            this.textArea.append("\u4f8b\u5916\u304c\u767a\u751f\u3057\u305f\u305f\u3081\u51e6\u7406\u3092\u4e2d\u65ad\u3057\u307e\u3059\n");
            return null;
        }
        finally {
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    protected void done() {
        if (this.isCancelled()) {
            this.textArea.append("\u4e2d\u65ad\u51e6\u7406\u958b\u59cb\n");
        } else {
            this.textArea.append("\u5b8c\u4e86\n");
        }
        this.button.setEnabled(true);
    }

    public boolean login(TextDownloader downloader) {
        HashMap<String, String> loginPostValues = new HashMap<String, String>();
        loginPostValues.put("cardNumber", this.configData.getCardNumber());
        loginPostValues.put("password", PasswordUtility.decode(this.configData.getPassword()));
        String source = null;
        try {
            source = downloader.download("https://www.clubdam.com/app/auth/memMemberLogin.do", loginPostValues);
        }
        catch (IOException e) {
            this.textArea.append("\u30ed\u30b0\u30a4\u30f3\u30da\u30fc\u30b8\u306b\u63a5\u7d9a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\n");
            return false;
        }
        if (source == null) {
            this.textArea.append("\u30ed\u30b0\u30a4\u30f3\u30da\u30fc\u30b8\u306b\u63a5\u7d9a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\n");
            return false;
        }
        LoginPageParser parser = null;
        try {
            parser = new LoginPageParser(new BufferedReader(new StringReader(source)));
        }
        catch (IOException e) {
            return false;
        }
        return parser.isLogin();
    }

    public void updateResultData(TextDownloader downloader, int page) {
        String source = null;
        this.textArea.append("\u7cbe\u5bc6\u63a1\u70b9(\u30d7\u30e9\u30b9) " + page + "\u30da\u30fc\u30b8\u76ee\n");
        try {
            source = downloader.download("https://www.clubdam.com/app/membership/marking/listUp.do?page=" + page);
        }
        catch (IOException e) {
            this.textArea.append("\u7cbe\u5bc6\u63a1\u70b9" + page + "\u30da\u30fc\u30b8\u76ee\u306b\u63a5\u7d9a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\n");
            return;
        }
        if (source == null) {
            this.textArea.append("\u7cbe\u5bc6\u63a1\u70b9" + page + "\u30da\u30fc\u30b8\u76ee\u306b\u63a5\u7d9a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\n");
            return;
        }
        SeimitsuPageParser parser = null;
        try {
            parser = new SeimitsuPageParser(new BufferedReader(new StringReader(source)));
        }
        catch (IOException e) {
            this.textArea.append("\u30da\u30fc\u30b8\u306e\u89e3\u6790\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\n");
            return;
        }
        Map<SongId, SongData> dlSongDataList = parser.getSongDataList();
        Map<ResultDate, ResultData> dlResultDataList = parser.getResultDataList();
        int updateSongDataCount = 0;
        for (Map.Entry<SongId, SongData> entry : dlSongDataList.entrySet()) {
            if (this.songData.hasSongData(entry.getKey())) continue;
            this.songData.add(entry.getKey(), entry.getValue());
            ++updateSongDataCount;
        }
        this.textArea.append(" \u66f2\u30c7\u30fc\u30bf: " + updateSongDataCount + "/" + dlSongDataList.size() + "\u4ef6\u8ffd\u52a0\n");
        int updateResultDataCount = 0;
        for (Map.Entry<ResultDate, ResultData> entry : dlResultDataList.entrySet()) {
            if (this.resultData.hasResultData(entry.getKey())) continue;
            this.resultData.add(entry.getKey(), entry.getValue());
            ++updateResultDataCount;
        }
        this.textArea.append(" \u7d50\u679c\u30c7\u30fc\u30bf: " + updateResultDataCount + "/" + dlResultDataList.size() + "\u4ef6\u8ffd\u52a0\n");
    }

    public void updateResultData2(TextDownloader downloader, int page) {
        String source = null;
        this.textArea.append("\u7cbe\u5bc6\u63a1\u70b9II " + page + "\u30da\u30fc\u30b8\u76ee\n");
        try {
            source = downloader.download("https://www.clubdam.com/app/membership/marking/listUpMarkingTwo.do?page=" + page);
        }
        catch (IOException e) {
            this.textArea.append("\u7cbe\u5bc6\u63a1\u70b9II" + page + "\u30da\u30fc\u30b8\u76ee\u306b\u63a5\u7d9a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\n");
            return;
        }
        if (source == null) {
            this.textArea.append("\u7cbe\u5bc6\u63a1\u70b9II" + page + "\u30da\u30fc\u30b8\u76ee\u306b\u63a5\u7d9a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\n");
            return;
        }
        Seimitsu2PageParser parser = null;
        try {
            parser = new Seimitsu2PageParser(new BufferedReader(new StringReader(source)));
        }
        catch (IOException e) {
            this.textArea.append("\u30da\u30fc\u30b8\u306e\u89e3\u6790\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\n");
            return;
        }
        Map<SongId, SongData> dlSongDataList = parser.getSongDataList();
        Map<ResultDate, ResultData2> dlResultData2List = parser.getResultData2List();
        int updateSongDataCount = 0;
        for (Map.Entry<SongId, SongData> entry : dlSongDataList.entrySet()) {
            if (this.songData.hasSongData(entry.getKey())) continue;
            this.songData.add(entry.getKey(), entry.getValue());
            ++updateSongDataCount;
        }
        this.textArea.append(" \u66f2\u30c7\u30fc\u30bf: " + updateSongDataCount + "/" + dlSongDataList.size() + "\u4ef6\u8ffd\u52a0\n");
        int updateResultData2Count = 0;
        for (Map.Entry<ResultDate, ResultData2> entry : dlResultData2List.entrySet()) {
            if (this.resultData2.hasResultData(entry.getKey())) continue;
            this.resultData2.add(entry.getKey(), entry.getValue());
            ++updateResultData2Count;
        }
        this.textArea.append(" \u7d50\u679c\u30c7\u30fc\u30bf: " + updateResultData2Count + "/" + dlResultData2List.size() + "\u4ef6\u8ffd\u52a0\n");
    }
}

