/* $Id: cxp-entry-dialog.h,v 1.6 2005/04/17 18:03:18 yasumichi Exp $ */
/**
 * \if japanese
 * @file
 * @brief 桼ʸϤ
 *
 * @author 
 * @date Sat Feb 12 2005
 * $Revision: 1.6 $
 * \endif
 * \if english
 * @file
 * @brief Dialog to request input of character string from user
 *
 * @author Yasumichi Akahoshi
 * @date Sat Feb 12 2005
 * $Revision: 1.6 $
 * \endif
 */


/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef CXP_ENTRY_DIALOG_H
#define CXP_ENTRY_DIALOG_H

/*
 * Potentially, include other headers on which this header depends.
 */
#include <gtk/gtk.h>
#include <glib-object.h>

/**
 * \if japanese
 * @brief CxpEntryDialogΥˡʼ̻Ҥ롣
 *
 * \endif
 * \if english
 * @brief A unique identifier of the CxpEntryDialog type is obtained. 
 *
 * \endif
 */
#define CXP_TYPE_ENTRY_DIALOG		  (cxp_entry_dialog_get_type ())

/**
 * \if japanese
 * @brief objCxpEntryDialog˥㥹Ȥ롣
 *
 * \endif
 * \if english
 * @brief It is Cast in the CxpEntryDialog type as for obj. 
 *
 * \endif
 */
#define CXP_ENTRY_DIALOG(obj)		  (G_TYPE_CHECK_INSTANCE_CAST ((obj), CXP_TYPE_ENTRY_DIALOG, CxpEntryDialog))

/**
 * \if japanese
 * @brief vtableCxpEntryDialogClass˥㥹Ȥ롣
 *
 * \endif
 * \if english
 * @brief It is Cast in the CxpEntryDialogClass type as for vtable. 
 *
 * \endif
 */
#define CXP_ENTRY_DIALOG_CLASS(klass)	  (G_TYPE_CHECK_CLASS_CAST ((klass), CXP_TYPE_ENTRY_DIALOG, CxpEntryDialogClass))

/**
 * \if japanese
 * @brief objCxpEntryDialogǤ뤫ǧ롣
 *
 * \endif
 * \if english
 * @brief Whether obj is CxpEntryDialog type is confirmed. 
 *
 * \endif
 */
#define CXP_IS_ENTRY_DIALOG(obj)	  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CXP_TYPE_ENTRY_DIALOG))

/**
 * \if japanese
 * @brief vtableCxpEntryDialogClassǤ뤫ǧ롣
 *
 * \endif
 * \if english
 * @brief Whether vtable is CxpEntryDialogClass type is confirmed.
 *
 * \endif
 */
#define CXP_IS_ENTRY_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CXP_TYPE_ENTRY_DIALOG))

/**
 * \if japanese
 * @brief 󥹥inst顢CxpEntryDialogClass롣
 *
 * \endif
 * \if english
 * @brief The CxpEntryDialogClass type is obtained from instance inst. 
 *
 * \endif
 */
#define CXP_ENTRY_DIALOG_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), CXP_TYPE_ENTRY_DIALOG, CxpEntryDialogClass))

typedef struct
{
	GtkDialog parent;
} CxpEntryDialog;

typedef struct
{
	GtkDialogClass parent;
} CxpEntryDialogClass;

/* used by CXP_TYPE_ENTRY_DIALOG */
GType cxp_entry_dialog_get_type (void);

/* API. */
GtkWidget *cxp_entry_dialog_new (const gchar * title, const gchar * message,
				 const gchar * entry_text);
gchar *cxp_entry_dialog_get_entry_text (CxpEntryDialog * dialog);

#endif /* CXP_ENTRY_DIALOG_H */
