/*
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.lunchorder.LunchOrderMapInputFormData;
import com.aimluck.eip.lunchorder.LunchOrderMapReturnInputFormData;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 弁当注文表登録画面を処理するクラスです。 <br />
 * 
 */
public class LunchOrderMapInputFormScreen extends ALVelocityScreen {
  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(LunchOrderInputFormScreen.class.getName());

  private static final String RETURN_INPUT_FORM_FROM_PREVIEW_PAGES = "T";

  private static final String RETURN_INPUT_FORM_FROM_TOP_PAGES = "F";

  /**
   * @see org.apache.turbine.modules.screens.RawScreen#doOutput(org.apache.turbine.util.RunData)
   */
  @Override
  protected void doOutput(RunData rundata, Context context) throws Exception {

    try {
      String preview = rundata.getParameters().getString("preview");
      if ((RETURN_INPUT_FORM_FROM_PREVIEW_PAGES).equals(preview)) {// プレビュー画面から「戻る」ボタン押下時の処理
        doLunchOrderMap_returnForm(rundata, context);
      } else {// ポートレットのトップからの場合の処理
        doLunchOrderMap_form(rundata, context);
      }
    } catch (Exception ex) {
      logger.error("[LunchOrderMapInputFormScreen] Exception.", ex);
      ALEipUtils.redirectDBError(rundata);
    }
  }

  /**
   * ポートレットのトップからの場合
   */
  protected void doLunchOrderMap_form(RunData rundata, Context context) {

    LunchOrderMapInputFormData formData = new LunchOrderMapInputFormData();
    formData.initField();
    formData.setReturnFlag(RETURN_INPUT_FORM_FROM_TOP_PAGES);
    formData.doViewForm(this, rundata, context);
    formData.clearLunchOrderMapPreViewSession(rundata, context);
    String layout_template = "portlets/html/ja/ajax-lunchorder-map-form.vm";
    setTemplate(rundata, context, layout_template);
  }

  /**
   * プレビュー画面から遷移した場合
   */
  protected void doLunchOrderMap_returnForm(RunData rundata, Context context) {

    LunchOrderMapReturnInputFormData formData = new LunchOrderMapReturnInputFormData();
    formData.initField();
    formData.doViewForm(this, rundata, context);
    formData.loadPreViewReturnList(rundata, context);
    String layout_template = "portlets/html/ja/ajax-lunchorder-map-form.vm";
    setTemplate(rundata, context, layout_template);
  }
}
