/*
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */


package com.aimluck.eip.modules.screens;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.lunchorder.LunchOrderInputFormSelectData;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 注文入力を処理するクラスです。 <br />
 * 
 */
public class LunchOrderInputFormScreen extends ALVelocityScreen {
  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(LunchOrderInputFormScreen.class.getName());

  /**
   * @see org.apache.turbine.modules.screens.RawScreen#doOutput(org.apache.turbine.util.RunData)
   */
  @Override
  protected void doOutput(RunData rundata, Context context) throws Exception {

    try {
      doLunchOrderInput_form(rundata, context);
    } catch (Exception ex) {
      logger.error("[LunchOrderFormScreen] Exception.", ex);
      ALEipUtils.redirectDBError(rundata);
    }
  }

  protected void doLunchOrderInput_form(RunData rundata, Context context) {
    LunchOrderInputFormSelectData formSelectData = new LunchOrderInputFormSelectData();
    formSelectData.initField();
    formSelectData.doViewList(this, rundata, context);// DBからのオブジェクトをコンテキストに入れるだけの処理
    String layout_template = "portlets/html/ja/ajax-lunchorder-form.vm";// 使用するテンプレートを指定
    setTemplate(rundata, context, layout_template);// 使用するテンプレートを設定
  }
}
