/*
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.lunchorder;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;

/**
 * 注文集計（ユーザー毎）のResultDataです。 <BR>
 * 
 */
public class LunchOrderForUserTotalResultData implements ALData {

  /** 注文者名　*/
  private ALStringField order_user_name;

  /** 弁当名 */
  private ALStringField order_item_name;

  /** 注文数　*/
  private ALNumberField order_amount;

  /** 金額 */
  private ALNumberField order_price;

  public void initField() {
    order_user_name = new ALStringField();
    order_item_name = new ALStringField();
    order_amount = new ALNumberField();
    order_price = new ALNumberField();
  }

  public ALStringField getOrderUserName() {
    return order_user_name;
  }

  public void setOrderUserName(String string) {
    order_user_name.setValue(string);
  }

  public ALStringField getOrderItemName() {
    return order_item_name;
  }

  public void setOrderItemName(String string) {
    order_item_name.setValue(string);
  }

  public ALNumberField getOrderAmount() {
    return order_amount;
  }

  public void setOrderAmount(int i) {
    order_amount.setValue(i);
  }

  public ALNumberField getOrderPrice() {
    return order_price;
  }

  public void setOrderPrice(int i) {
    order_price.setValue(i);
  }

}
