/* 
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * History
 * 2010/06/30 avanza Co.,Ltd.
 * -スケジュール登録時における参加メンバー選択方式にMyGroupを追加
 * -施設予約承認機能追加
 */
package com.aimluck.eip.modules.screens;

import net.sf.json.JSONArray;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.schedule.util.ScheduleUtils;

/**
 * グループ情報をJSONデータとして出力するクラスです。 <br />
 * 
 */
public class ScheduleLiteJSONScreen extends ALJSONScreen {
  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(ScheduleLiteJSONScreen.class.getName());

  protected String getJSONString(RunData rundata, Context context)
      throws Exception {
    String result = "";
    JSONArray json;

    try {

      String mode = rundata.getParameters().getString("mode");
      if ("mygroup".equals(mode)) {
        json = JSONArray.fromObject(ScheduleUtils.getUserGroupLiteBeans(rundata,
            true, false));
      } else if ("post".equals(mode)) {
        json = JSONArray.fromObject(ScheduleUtils.getUserGroupLiteBeans(rundata,
            false, true));
      } else {
        json = JSONArray.fromObject(ScheduleUtils.getUserGroupLiteBeans(rundata,
            true, true));
      }

      result = json.toString();
    } catch (Exception e) {
      logger.error("[UserLiteJSONScreen]", e);
    }

    return result;
  }
}
