/*
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.enquete;

import java.util.ArrayList;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;

/**
 * ワークフローのResultDataです。 <BR>
 * 
 */
public class EnqueteChoiceItemRecordData implements ALData {

  private ALStringField choice_item_title;

  private String select_status;

  private String response;

  private Integer choice_selected;

  private double choice_percnt;

  /** 回答者リスト */
  private ArrayList<ALStringField> answerList;

  /** 回答者 */
  private ALStringField answer;

  /** 選択項目番号 */
  private Integer choice_item_number;

  /** フリーテキスト回答数 */
  private Integer freeTextLength;
  
  /** CSV出力用回答内容 */
  private String csvChoiceItem;

  public void initField() {

    choice_item_title = new ALStringField();
    select_status = new String();
    response = new String();
    choice_selected = new Integer(choice_selected);
    choice_percnt = new Double(choice_percnt);
    answerList = new ArrayList<ALStringField>();
    answer = new ALStringField();
    freeTextLength = new Integer(freeTextLength);
    csvChoiceItem = new String();

  }

  public ALStringField getChoiceItemTitle() {
    return choice_item_title;
  }

  public void setChoiceItemTitle(ALStringField choice_item_title) {
    this.choice_item_title = choice_item_title;
  }

  public String getSelectStatus() {
    return select_status;
  }

  public void setSelectStatus(String select_status) {
    this.select_status = select_status;
  }

  public String getResponse() {
    return response;
  }

  public void setResponse(String response) {
    this.response = response;
  }

  public Integer getChoiceSelected() {
    return choice_selected;
  }

  public void setChoiceSelected(Integer choice_selected) {
    this.choice_selected = choice_selected;
  }

  public double getChoicePercnt() {
    return choice_percnt;
  }

  public void setChoicePercnt(double choice_percnt) {
    this.choice_percnt = choice_percnt;
  }

  public ArrayList<ALStringField> getAnswerList() {
    return answerList;
  }

  public void setAnswerList(ArrayList<ALStringField> answerList) {
    this.answerList = answerList;
  }

  public ALStringField getAnswer() {
    return answer;
  }

  public void setAnswer(ALStringField answer) {
    this.answer = answer;
  }

  public Integer getChoiceItemNumber() {
    return choice_item_number;
  }

  public void setChoiceItemNumber(Integer choice_item_number) {
    this.choice_item_number = choice_item_number;
  }

  public Integer getFreeTextLength() {
    return freeTextLength;
  }

  public void setFreeTextLength(Integer freeTextLength) {
    this.freeTextLength = freeTextLength;
  }

  public String getCsvChoiceItem() {
    return csvChoiceItem;
  }

  public void setCsvChoiceItem(String csvChoiceItem) {
    this.csvChoiceItem = csvChoiceItem;
  }

}
