/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.extcabinet;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.extcabinet.util.ExtCabinetUtils;
import com.aimluck.eip.cayenne.om.portlet.AvzTCabinetFolder;
import com.aimluck.eip.cayenne.om.portlet.AvzTFolderAcl;
import com.aimluck.eip.cayenne.om.portlet.auto._AvzTFolderAcl;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 文書管理のROOTフォルダフォームデータを管理するクラス <BR>
 *
 */
public class ExtCabinetAdminRootFormData extends ALAbstractFormData {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(ExtCabinetAdminRootFormData.class.getName());

  /** メモ */
  private ALStringField note;

  private DataContext dataContext;
  
  /** アクセス権限リスト by motegi 　*/
  private List<Map<String, String>> aclRequestList;
  
  /** アクセス権限リスト（更新時表示用） by motegi */
  private List<ExtCabinetAclResultData> aclList;

  /**
   *
   * @param action
   * @param rundata
   * @param context
   * @see com.aimluck.eip.common.ALAbstractFormData#init(com.aimluck.eip.modules.actions.common.ALAction,
   *      org.apache.turbine.util.RunData, org.apache.velocity.context.Context)
   */
  @Override
  public void init(ALAction action, RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {

    super.init(action, rundata, context);

    //フォルダはROOTフォルダ固定にします。
    ALEipUtils.setTemp(rundata, context, ExtCabinetUtils.SESSION_KEY_FOLDER_ID,
    		String.valueOf(ExtCabinetUtils.ROOT_FODLER_ID));
    
    dataContext = DatabaseOrmService.getInstance().getDataContext();
  }

  /*
   * @see com.aimluck.eip.common.ALAbstractFormData#setFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context, java.util.ArrayList)
   */
  @Override
  protected boolean setFormData(RunData rundata, Context context,
      ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {

    boolean res = super.setFormData(rundata, context, msgList);
    if (res) {
      if (ALEipConstants.MODE_UPDATE.equals(getMode())) {
        aclRequestList = new ArrayList<Map<String, String>>();
        String[] target_ids = rundata.getParameters().getStrings("acl[target_id][]");
        String[] target_types = rundata.getParameters().getStrings("acl[target_type][]");
        String[] f = rundata.getParameters().getStrings("acl[file_creatable][]");
        String[] c = rundata.getParameters().getStrings("acl[folder_creatable][]");
        if( target_ids!=null && target_ids.length>0 ) {
          int acl_num = target_ids.length;
          for( int i=0; i<acl_num; i++ ) {
            Map<String, String> map = new HashMap<String, String>();
            map.put(ExtCabinetUtils.AUTHORITY_TARGET_ID, target_ids[i]);
            map.put(ExtCabinetUtils.AUTHORITY_TARGET_TYPE, target_types[i]);
            map.put(ExtCabinetUtils.AUTHORITY_F, f[i]);
            map.put(ExtCabinetUtils.AUTHORITY_C, c[i]);
            //Rootフォルダのデフォルト権限を設定
            map.put(ExtCabinetUtils.AUTHORITY_R, ExtCabinetUtils.AUTHORITY_ON);
            map.put(ExtCabinetUtils.AUTHORITY_U, ExtCabinetUtils.AUTHORITY_OFF);
            map.put(ExtCabinetUtils.AUTHORITY_D, ExtCabinetUtils.AUTHORITY_OFF);
            aclRequestList.add(map);
          }
        }
      }
    }
    return res;
  }

  /**
   * 各フィールドを初期化します。 <BR>
   *
   * @see com.aimluck.eip.common.ALData#initField()
   */
  public void initField() {
    // メモ
    note = new ALStringField();
    note.setFieldName("メモ");
    note.setTrim(true);
  }

  /**
   * フォルダの各フィールドに対する制約条件を設定します。 <BR>
   *
   * @see com.aimluck.eip.common.ALAbstractFormData#setValidator()
   */
  @Override
  protected void setValidator() {
    // メモの文字数制限
    note.limitMaxLength(1000);
  }

  /**
   * フォルダのフォームに入力されたデータの妥当性検証を行います。 <BR>
   *
   * @param msgList
   * @return TRUE 成功 FALSE 失敗
   * @see com.aimluck.eip.common.ALAbstractFormData#validate(java.util.ArrayList)
   */
  @Override
  protected boolean validate(ArrayList msgList) {
    note.validate(msgList);
    return (msgList.size() == 0);
  }

  /**
   * フォルダをデータベースから読み出します。 <BR>
   *
   * @param rundata
   * @param context
   * @param msgList
   * @return TRUE 成功 FALSE 失敗
   * @see com.aimluck.eip.common.ALAbstractFormData#loadFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context)
   */
  @Override
  protected boolean loadFormData(RunData rundata, Context context,
      ArrayList msgList) {
    try {
      // オブジェクトモデルを取得
      AvzTCabinetFolder folder = ExtCabinetUtils.getAvzTCabinetFolder(rundata,
          context);
      if (folder == null){
        return false;
      }

      note.setValue(folder.getNote());
      aclList = ExtCabinetUtils.loadFolderAclList(folder.getFolderId());

    } catch (Exception ex) {
      logger.error("Exception", ex);
      return false;
    }
    return true;
  }

  /**
   * フォルダをデータベースとファイルシステムから削除します。 <BR>
   *
   * @param rundata
   * @param context
   * @param msgList
   * @return TRUE 成功 FALSE 失敗
   * @see com.aimluck.eip.common.ALAbstractFormData#deleteFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context)
   */
  @Override
  protected boolean deleteFormData(RunData rundata, Context context,
      ArrayList msgList) {
    return true;
  }

  /**
   * フォルダをデータベースとファイルシステムに格納します。 <BR>
   *
   * @param rundata
   * @param context
   * @param msgList
   * @return TRUE 成功 FALSE 失敗
   * @see com.aimluck.eip.common.ALAbstractFormData#insertFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context, java.util.ArrayList)
   */
  @Override
  protected boolean insertFormData(RunData rundata, Context context,
      ArrayList msgList) {
    return true;
  }

  /**
   * データベースとファイルシステムに格納されているフォルダを更新します。 <BR>
   *
   * @param rundata
   * @param context
   * @param msgList
   * @return TRUE 成功 FALSE 失敗O
   * @see com.aimluck.eip.common.ALAbstractFormData#updateFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context, java.util.ArrayList)
   */
  @Override
  protected boolean updateFormData(RunData rundata, Context context,
      ArrayList msgList) {
    try {
      // オブジェクトモデルを取得
      AvzTCabinetFolder folder = ExtCabinetUtils.getAvzTCabinetFolder(rundata,
          context);
      if (folder == null)
        return false;

      int uid = ALEipUtils.getUserId(rundata);

      // メモ
      folder.setNote(note.getValue());
      // 更新者
      folder.setUpdateUserId(Integer.valueOf(uid));
      // 更新日
      folder.setUpdateDate(Calendar.getInstance().getTime());

      SelectQuery query = new SelectQuery(AvzTFolderAcl.class);
			Expression exp01 = ExpressionFactory.matchExp(
					_AvzTFolderAcl.FOLDER_ID_PROPERTY, folder.getFolderId());
			query.setQualifier(exp01);
			List acls = dataContext.performQuery(query);
			dataContext.deleteObjects(acls);

			ExtCabinetUtils.insertFolderAcl(folder, aclRequestList);
			
      // フォルダを更新
      dataContext.commitChanges();

    } catch (Exception ex) {
      dataContext.rollbackChanges();
      logger.error("Exception", ex);
      return false;
    }
    return true;
  }
  
  /**
   * メモを取得する． <BR>
   *
   * @return
   */
  public ALStringField getNote() {
    return note;
  }

  /**
   * アクセス権限チェック用メソッド。<br />
   * アクセス権限の機能名を返します。
   *
   * @return
   */
  @Override
  public String getAclPortletFeature() {
    return null;
  }

  public Map getPostMap() {
    return ALEipManager.getInstance().getPostMap();
  }
  
  public List<ExtCabinetAclResultData> getAclList() {
    return aclList;
  }

}
