/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.modules.actions.intramail;

import java.util.ArrayList;
import java.util.List;

import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.modules.actions.common.ALBaseAction;
import com.aimluck.eip.intramail.IntraMailDraftSelectData;
import com.aimluck.eip.intramail.IntraMailReceiveSelectData;
import com.aimluck.eip.intramail.IntraMailSendSelectData;
import com.aimluck.eip.util.ALEipUtils;


/**
 * IntraMailのアクションクラスです。 <BR>
 * 
 */
public class IntraMailAction extends ALBaseAction {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(IntraMailAction.class.getName());

  /**
   * 通常表示の際の処理を記述します。 <BR>
   * 
   * @param portlet
   * @param context
   * @param rundata
   * @throws Exception
   * @see org.apache.jetspeed.modules.actions.portlets.VelocityPortletAction#buildNormalContext(org.apache.jetspeed.portal.portlets.VelocityPortlet,
   *      org.apache.velocity.context.Context, org.apache.turbine.util.RunData)
   */
  @Override
  protected void buildNormalContext(VelocityPortlet portlet, Context context,
      RunData rundata) throws Exception {

    // セッション情報のクリア
    clearIntramailSession(rundata, context);

    IntraMailReceiveSelectData listData = new IntraMailReceiveSelectData();
    listData.initField();
    listData.setRowsNum(Integer.parseInt(portlet.getPortletConfig()
        .getInitParameter("p1a-rows")));
    listData.setStrLength(Integer.parseInt(ALEipUtils.getPortlet(rundata,
        context).getPortletConfig().getInitParameter("p5a-strlen")));
    listData.doViewList(this, rundata, context);
    
    setTemplate(rundata, "intramail");
  }

  /**
   * 最大化表示の際の処理を記述します。 <BR>
   * 
   * @param portlet
   * @param context
   * @param rundata
   */
  @Override
  protected void buildMaximizedContext(VelocityPortlet portlet,
      Context context, RunData rundata) {
    try {
    	if (getMode() == null) {
    	  doIntramail_receive_list(rundata, context);
    	}
    } catch (Exception ex) {
      logger.error("Exception", ex);
    }
  }

  /**
   * 受信トレイを表示します。 <BR>
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doIntramail_receive_list(RunData rundata, Context context) throws Exception {
    IntraMailReceiveSelectData listData = new IntraMailReceiveSelectData();
    listData.initField();
    listData.setBuildNormal(false);

    // PSMLからパラメータをロードする
    // 最大表示件数（最大化時）
    listData.setRowsNum(Integer.parseInt(ALEipUtils
        .getPortlet(rundata, context).getPortletConfig().getInitParameter(
            "p1b-rows")));
    listData.setStrLength(Integer.parseInt(ALEipUtils.getPortlet(rundata,
        context).getPortletConfig().getInitParameter("p5a-strlen")));
    listData.doViewList(this, rundata, context);
    setTemplate(rundata, "intramail-receive-list");
  }
  
  /**
   *　送信トレイを表示します。 <BR>
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doIntramail_send_list(RunData rundata, Context context) throws Exception {
    IntraMailSendSelectData listData = new IntraMailSendSelectData();
    listData.initField();
    listData.setBuildNormal(false);

    // PSMLからパラメータをロードする
    // 最大表示件数（最大化時）
    listData.setRowsNum(Integer.parseInt(ALEipUtils
        .getPortlet(rundata, context).getPortletConfig().getInitParameter(
            "p1b-rows")));
    listData.setStrLength(Integer.parseInt(ALEipUtils.getPortlet(rundata,
        context).getPortletConfig().getInitParameter("p5a-strlen")));
    listData.doViewList(this, rundata, context);
    setTemplate(rundata, "intramail-send-list");
  }
  
  /**
   *　下書きトレイを表示します。 <BR>
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doIntramail_draft_list(RunData rundata, Context context) throws Exception {
    IntraMailDraftSelectData listData = new IntraMailDraftSelectData();
    listData.initField();
    listData.setBuildNormal(false);

    // PSMLからパラメータをロードする
    // 最大表示件数（最大化時）
    listData.setRowsNum(Integer.parseInt(ALEipUtils
        .getPortlet(rundata, context).getPortletConfig().getInitParameter(
            "p1b-rows")));
    listData.setStrLength(Integer.parseInt(ALEipUtils.getPortlet(rundata,
        context).getPortletConfig().getInitParameter("p5a-strlen")));
    listData.doViewList(this, rundata, context);
    setTemplate(rundata, "intramail-draft-list");
  }

  /**
   * セッションクリア
   * @param rundata
   * @param context
   */
  private void clearIntramailSession(RunData rundata, Context context) {
    List<String> list = new ArrayList<String>();
    list.add("entityid");
    list.add("com.aimluck.eip.intramail.IntraMailReceiveSelectDatasort");
    list.add("com.aimluck.eip.intramail.IntraMailReceiveSelectDatasorttype");
    list.add("com.aimluck.eip.intramail.IntraMailSendSelectDatasort");
    list.add("com.aimluck.eip.intramail.IntraMailSendSelectDatasorttype");
    list.add("com.aimluck.eip.intramail.IntraMailDraftSelectDatasort");
    list.add("com.aimluck.eip.intramail.IntraMailDraftSelectDatasorttype");
    ALEipUtils.removeTemp(rundata, context, list);
  }

}
