-- Table: avz_t_circulation_category

-- DROP TABLE avz_t_circulation_category;

CREATE TABLE avz_t_circulation_category
(
  category_id serial NOT NULL,
  user_id integer NOT NULL,
  category_name character varying(64) NOT NULL,
  note character varying,
  create_date date,
  update_date timestamp without time zone,
  "template" character varying,
  CONSTRAINT avz_t_circulation_category_pkey PRIMARY KEY (category_id)
)
WITHOUT OIDS;
ALTER TABLE avz_t_circulation_category OWNER TO aipo_postgres;

-- Table: avz_t_circulation_request

-- DROP TABLE avz_t_circulation_request;

CREATE TABLE avz_t_circulation_request
(
  request_id serial NOT NULL,
  user_id integer NOT NULL,
  request_name character varying(64),
  category_id integer,
  priority smallint,
  progress character varying(1),
  note character varying,
  create_date timestamp without time zone,
  update_date timestamp without time zone,
  limit_date timestamp(6) without time zone,
  CONSTRAINT avz_t_circulation_request_pkey PRIMARY KEY (request_id),
  CONSTRAINT avz_t_circulation_request_category_id_fkey FOREIGN KEY (category_id)
      REFERENCES avz_t_circulation_category (category_id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE CASCADE
)
WITHOUT OIDS;
ALTER TABLE avz_t_circulation_request OWNER TO aipo_postgres;



-- Table: avz_t_circulation_request_map

-- DROP TABLE avz_t_circulation_request_map;

CREATE TABLE avz_t_circulation_request_map
(
  id serial NOT NULL,
  request_id integer NOT NULL,
  user_id integer NOT NULL,
  status character varying(1),
  note character varying,
  create_date date,
  update_date timestamp without time zone,
  CONSTRAINT avz_t_circulation_request_map_pkey PRIMARY KEY (id),
  CONSTRAINT avz_t_circulation_request_map_request_id_fkey FOREIGN KEY (request_id)
      REFERENCES avz_t_circulation_request (request_id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE CASCADE
)
WITHOUT OIDS;
ALTER TABLE avz_t_circulation_request_map OWNER TO aipo_postgres;


-- Table: avz_t_circulation_file

-- DROP TABLE avz_t_circulation_file;

CREATE TABLE avz_t_circulation_file
(
  file_id serial NOT NULL,
  owner_id integer,
  request_id integer,
  file_name character varying(128) NOT NULL,
  file_path character varying NOT NULL,
  file_thumbnail bytea,
  create_date date,
  update_date timestamp without time zone,
  CONSTRAINT avz_t_circulation_file_pkey PRIMARY KEY (file_id),
  CONSTRAINT avz_t_circulation_file_request_id_fkey FOREIGN KEY (request_id)
      REFERENCES avz_t_circulation_request (request_id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE CASCADE
)
WITHOUT OIDS;
ALTER TABLE avz_t_circulation_file OWNER TO aipo_postgres;

-----------------------------------------------------------------------------
-----------------------------------------------------------------------------
-- Default Data Insert
-----------------------------------------------------------------------------
-----------------------------------------------------------------------------
INSERT INTO avz_t_circulation_category VALUES(1,0,'未分類','',NULL,NULL,'');
SELECT setval('avz_t_circulation_category_category_id_seq',1);
