/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.whereaboutsinformation.util;

import com.aimluck.eip.cayenne.om.portlet.AvzTWhereaboutsinformation;
import com.aimluck.eip.cayenne.om.portlet.EipMFacility;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class WhereaboutsInformationUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WhereaboutsInformationUtils.class.getName());
    public static final String SCHEDULEMAP_TYPE_USER = "U";
    public static final String SCHEDULEMAP_TYPE_FACILITY = "F";
    public static final String STATUS_PRESENCE = "P";
    public static final String STATUS_ABSENCE = "A";
    public static final String PERMISSION_ON = "P";
    public static final String PERMISSION_OFF = "A";

    public static String getPlace(EipTSchedule schedule) {
        String place = schedule.getPlace();
        if (place.length() == 0) {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery mapquery = new SelectQuery(EipTScheduleMap.class);
            Expression mapexp1 = ExpressionFactory.matchExp((String)"scheduleId", (Object)schedule.getScheduleId());
            mapquery.setQualifier(mapexp1);
            Expression mapexp3 = ExpressionFactory.matchExp((String)"type", (Object)SCHEDULEMAP_TYPE_FACILITY);
            mapquery.andQualifier(mapexp3);
            StringBuffer buf_facility = new StringBuffer();
            List schedulemaps = dataContext.performQuery((Query)mapquery);
            if (schedulemaps != null && schedulemaps.size() != 0) {
                for (EipTScheduleMap map : schedulemaps) {
                    SelectQuery fquery = new SelectQuery(EipMFacility.class);
                    Expression fexp = ExpressionFactory.matchDbExp((String)"FACILITY_ID", (Object)map.getUserId());
                    fquery.setQualifier(fexp);
                    List aList = dataContext.performQuery((Query)fquery);
                    if (aList == null || aList.size() == 0) continue;
                    EipMFacility f = (EipMFacility)aList.get(0);
                    String facility = f.getFacilityName();
                    if (buf_facility.length() == 0) {
                        buf_facility.append(facility);
                        continue;
                    }
                    buf_facility.append(" \u3082\u3057\u304f\u306f " + facility);
                }
            }
            place = buf_facility.length() == 0 ? schedule.getName() : buf_facility.toString();
        }
        return place;
    }

    public static String translateDate(Date date, String dateFormat) {
        if (date == null) {
            return "Unknown";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        sdf.setTimeZone(TimeZone.getDefault());
        return sdf.format(date);
    }

    public static AvzTWhereaboutsinformation getAvzTwhereaboutsinformation(RunData rundata, Context context) throws ALPageNotFoundException {
        String whereaboutsinformationid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        int user_id = ALEipUtils.getUserId((RunData)rundata);
        try {
            if (Integer.valueOf(user_id) == null) {
                logger.debug((Object)"[user_id] Empty ID...");
                return null;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(AvzTWhereaboutsinformation.class);
            Expression exp = ExpressionFactory.matchExp((String)"userId", (Object)user_id);
            query.setQualifier(exp);
            List whereati = dataContext.performQuery((Query)query);
            if (whereati == null || whereati.size() == 0) {
                logger.debug((Object)"[wati] Not found ID...");
                return null;
            }
            return (AvzTWhereaboutsinformation)((Object)whereati.get(0));
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return null;
        }
    }

    public static AvzTWhereaboutsinformation getAvzTwhereaboutsinformationById(String userid) throws ALPageNotFoundException {
        try {
            if (userid == null || Integer.valueOf(userid) == null) {
                logger.debug((Object)"[Whereaboutsinformation] Empty ID...");
                return null;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(AvzTWhereaboutsinformation.class);
            Expression exp = ExpressionFactory.matchExp((String)"userId", (Object)userid);
            query.setQualifier(exp);
            List wati = dataContext.performQuery((Query)query);
            if (wati == null || wati.size() == 0) {
                logger.debug((Object)"[wati] Not found ID...");
                return null;
            }
            return (AvzTWhereaboutsinformation)((Object)wati.get(0));
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return null;
        }
    }
}

