/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.whereaboutsinformation;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.cayenne.om.portlet.AvzTWhereaboutsinformation;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.whereaboutsinformation.WhereaboutsInformationContainer;
import com.aimluck.eip.whereaboutsinformation.WhereaboutsInformationResultData;
import com.aimluck.eip.whereaboutsinformation.util.WhereaboutsInformationUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhereaboutsInformationSelectData
extends ALAbstractSelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WhereaboutsInformationSelectData.class.getName());
    private ALDateTimeField nowDatestamp = null;
    private ALDateTimeField nowDate = null;
    private Calendar calendar = Calendar.getInstance();
    private List myGroupList = null;
    private DataContext dataContext = null;
    private static final SimpleDateFormat nowtime = new SimpleDateFormat("HHmmss");
    private static final SimpleDateFormat nowdate = new SimpleDateFormat("yyyyMMdd");
    private String currentTab;
    private String login_user_id = null;
    private String userid = null;
    private int UserIdVm;
    private int screenParm;

    public int getUserIdVm() {
        return this.UserIdVm;
    }

    public void setUserIdVm(int UserIdVm) {
        this.UserIdVm = UserIdVm;
    }

    public int getScreenParm() {
        return this.screenParm;
    }

    public void setScreenParm(int screenParm) {
        this.screenParm = screenParm;
    }

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        try {
            VelocityPortlet port;
            String screen;
            VelocityPortlet portlet;
            String groupName;
            String filter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
            if ((filter == null || filter.equals("")) && (groupName = (portlet = ALEipUtils.getPortlet((RunData)rundata, (Context)context)).getPortletConfig().getInitParameter("p3b-group")) != null) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR, (String)groupName);
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR, (String)"group");
            }
            if ((screen = (port = ALEipUtils.getPortlet((RunData)rundata, (Context)context)).getPortletConfig().getInitParameter("p2b-rows")) != null) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"screen", (String)screen);
                String scren = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"screen");
                this.screenParm = Integer.parseInt(scren);
            }
            super.init(action, rundata, context);
        }
        catch (Exception ex) {
            logger.debug((Object)"Exception", (Throwable)ex);
        }
        this.login_user_id = Integer.toString(ALEipUtils.getUserId((RunData)rundata));
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
    }

    protected List selectList(RunData rundata, Context context) {
        try {
            List myGroups = ALEipUtils.getMyGroups((RunData)rundata);
            this.myGroupList = new ArrayList();
            int length = myGroups.size();
            for (int i = 0; i < length; ++i) {
                this.myGroupList.add(myGroups.get(i));
            }
            String filter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
            String filter_type = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR);
            if (filter == null || filter_type == null || filter.equals("")) {
                return new ArrayList();
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            query.addOrdering("lastNameKana", true);
            List ulist = dataContext.performQuery((Query)query);
            ArrayList<TurbineUser> changedDrList = new ArrayList<TurbineUser>();
            TurbineUser myData = null;
            for (Object obj : ulist) {
                TurbineUser d = (TurbineUser)obj;
                if (d.getUserId().toString().equals(this.login_user_id)) {
                    myData = d;
                    continue;
                }
                changedDrList.add(d);
            }
            if (myData != null) {
                changedDrList.add(0, myData);
            }
            return this.buildPaginatedList(changedDrList);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected SelectQuery buildSelectQueryForFilter(SelectQuery query, RunData rundata, Context context) {
        String filter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
        String filter_type = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR);
        String crt_key = null;
        Attributes map = this.getColumnMap();
        if (filter == null || filter_type == null || filter.equals("")) {
            return query;
        }
        crt_key = map.getValue(filter_type);
        if (crt_key == null) {
            return query;
        }
        Expression exp = ExpressionFactory.matchExp((String)crt_key, (Object)filter);
        query.andQualifier(exp);
        this.current_filter = filter;
        this.current_filter_type = filter_type;
        return query;
    }

    protected Object getResultData(Object obj) {
        try {
            TurbineUser user = (TurbineUser)obj;
            SelectQuery query = new SelectQuery(AvzTWhereaboutsinformation.class);
            Expression exp = ExpressionFactory.matchExp((String)"userId", (Object)user.getUserId());
            query.setQualifier(exp);
            List list = this.dataContext.performQuery((Query)query);
            this.userid = String.valueOf(user.getUserId());
            WhereaboutsInformationContainer rd = new WhereaboutsInformationContainer();
            AvzTWhereaboutsinformation info = null;
            if (list.size() != 0) {
                info = WhereaboutsInformationUtils.getAvzTwhereaboutsinformationById(this.userid);
            }
            rd.initField();
            rd.setName(ALEipUtils.getUserFullName((int)user.getUserId()));
            rd.setUserId(user.getUserId().longValue());
            if (info != null) {
                String reDate;
                rd.setWhereaboutsId(info.getWhereaboutsinformationId().intValue());
                String sta = info.getStatus().toString();
                String perm = info.getPermission().toString();
                if (sta.equals("A")) {
                    rd.setStatus("A");
                    rd.setReason(info.getNote());
                    reDate = WhereaboutsInformationUtils.translateDate(info.getReturnDate(), "HH:mm");
                    rd.setReturnDate(reDate);
                } else if (sta.toString().equals("P")) {
                    rd.setStatus("P");
                    rd.setReason("");
                    reDate = "";
                    rd.setReturnDate(reDate);
                }
                if (perm.equals("P")) {
                    rd.setPermission("P");
                } else {
                    rd.setPermission("A");
                }
            } else {
                rd.setStatus("P");
                rd.setPermission("A");
                rd.setReason("");
            }
            StringBuffer buf_place = new StringBuffer();
            List<EipTScheduleMap> maps = this.getEipTScheduleMapsOnNow(user.getUserId());
            ArrayList<WhereaboutsInformationResultData> places = new ArrayList<WhereaboutsInformationResultData>();
            if (maps != null) {
                for (EipTScheduleMap map : maps) {
                    boolean hidden;
                    EipTSchedule schedule = map.getEipTSchedule();
                    String tmp_place = WhereaboutsInformationUtils.getPlace(schedule);
                    SelectQuery mapquery = new SelectQuery(EipTScheduleMap.class);
                    Expression mapexp1 = ExpressionFactory.matchExp((String)"scheduleId", (Object)map.getScheduleId());
                    mapquery.setQualifier(mapexp1);
                    Expression mapexp2 = ExpressionFactory.matchExp((String)"userId", (Object)this.login_user_id);
                    mapquery.andQualifier(mapexp2);
                    Expression mapexp3 = ExpressionFactory.noMatchExp((String)"status", (Object)"R");
                    mapquery.andQualifier(mapexp3);
                    List schedulemaps = this.dataContext.performQuery((Query)mapquery);
                    boolean is_member = schedulemaps != null && schedulemaps.size() > 0;
                    boolean publicable = schedule.getPublicFlag().equals("O");
                    if (!publicable && !is_member) {
                        tmp_place = "\u975e\u516c\u958b";
                    }
                    if ((hidden = schedule.getPublicFlag().equals("P")) && !is_member) continue;
                    WhereaboutsInformationResultData place = new WhereaboutsInformationResultData();
                    place.initField();
                    place.setUserId(user.getUserId().toString());
                    place.setScheduleId(schedule.getScheduleId().toString());
                    place.setPlace(tmp_place);
                    place.setPublicable(publicable);
                    place.setMember(is_member);
                    places.add(place);
                }
            }
            rd.setPlaces(places);
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(TurbineUser.class);
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    private List<EipTScheduleMap> getEipTScheduleMapsOnNow(int userId) {
        Expression exp00 = ExpressionFactory.noMatchExp((String)"type", (Object)"R");
        Expression exp01 = ExpressionFactory.noMatchExp((String)"type", (Object)"F");
        Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)userId);
        this.nowDatestamp = new ALDateTimeField("yyyy-MM-dd HH:mm:00");
        this.nowDate = new ALDateTimeField("yyyy-MM-dd");
        this.nowDatestamp.setValue(this.calendar.getTime());
        this.nowDate.setValue(this.calendar.getTime());
        String nn = this.nowDatestamp.getDay();
        String dayOfWeek = this.nowDatestamp.getDayOfWeek();
        String dayFlag = null;
        if (dayOfWeek.equals("\uff08\u65e5\uff09")) {
            dayFlag = "1______";
        } else if (dayOfWeek.equals("\uff08\u6708\uff09")) {
            dayFlag = "_1_____";
        } else if (dayOfWeek.equals("\uff08\u706b\uff09")) {
            dayFlag = "__1____";
        } else if (dayOfWeek.equals("\uff08\u6c34\uff09")) {
            dayFlag = "___1___";
        } else if (dayOfWeek.equals("\uff08\u6728\uff09")) {
            dayFlag = "____1__";
        } else if (dayOfWeek.equals("\uff08\u91d1\uff09")) {
            dayFlag = "_____1_";
        } else if (dayOfWeek.equals("\uff08\u571f\uff09")) {
            dayFlag = "______1";
        }
        Expression exp2 = ExpressionFactory.lessOrEqualExp((String)"eipTSchedule.startDate", (Object)this.nowDatestamp);
        Expression exp3 = ExpressionFactory.greaterOrEqualExp((String)"eipTSchedule.endDate", (Object)this.nowDatestamp);
        Expression exp6 = ExpressionFactory.matchExp((String)"eipTSchedule.repeatPattern", (Object)"N");
        Expression exp7 = ExpressionFactory.matchExp((String)"eipTSchedule.repeatPattern", (Object)"DL");
        Expression exp8 = ExpressionFactory.matchExp((String)"eipTSchedule.repeatPattern", (Object)"DN");
        Expression exp9 = ExpressionFactory.matchExp((String)"eipTSchedule.repeatPattern", (Object)("M" + nn + "L"));
        Expression exp10 = ExpressionFactory.matchExp((String)"eipTSchedule.repeatPattern", (Object)("M" + nn + "N"));
        Expression exp11 = ExpressionFactory.likeExp((String)"eipTSchedule.repeatPattern", (Object)("W" + dayFlag + "L"));
        Expression exp12 = ExpressionFactory.likeExp((String)"eipTSchedule.repeatPattern", (Object)("W" + dayFlag + "N"));
        SelectQuery query = new SelectQuery(EipTScheduleMap.class, exp00.andExp(exp01.andExp(exp1.andExp(exp2.andExp(exp3).andExp(exp6)).orExp(exp1.andExp(exp8.orExp(exp10).orExp(exp12))).orExp(exp1.andExp(exp7.orExp(exp9).orExp(exp11))))));
        List ulist = this.dataContext.performQuery((Query)query);
        ulist = this.judgeRepeatPatternWithTime(ulist, userId);
        if (ulist.size() == 0) {
            return null;
        }
        return ulist;
    }

    private List judgeRepeatPatternWithTime(List list, int userId) {
        ArrayList<EipTScheduleMap> judgeRepeatPatternWithTimeList = new ArrayList<EipTScheduleMap>();
        this.nowDatestamp = new ALDateTimeField("yyyy-MM-dd HH:mm:00");
        this.nowDatestamp.setValue(this.calendar.getTime());
        int length = list.size();
        for (int i = 0; i < length; ++i) {
            EipTScheduleMap emap = (EipTScheduleMap)list.get(i);
            String repeatPattern = emap.getEipTSchedule().getRepeatPattern();
            int timeOfStartDate = Integer.parseInt(nowtime.format(emap.getEipTSchedule().getStartDate()));
            int timeOfEndDate = Integer.parseInt(nowtime.format(emap.getEipTSchedule().getEndDate()));
            int dateOfStartDate = Integer.parseInt(nowdate.format(emap.getEipTSchedule().getStartDate()));
            int dateOfEndDate = Integer.parseInt(nowdate.format(emap.getEipTSchedule().getEndDate()));
            int nowTime = Integer.parseInt(nowtime.format(this.nowDatestamp.getValue()));
            int nowDate = Integer.parseInt(nowdate.format(this.nowDatestamp.getValue()));
            if (repeatPattern.equals("N")) {
                judgeRepeatPatternWithTimeList.add(emap);
                continue;
            }
            if (repeatPattern.endsWith("N")) {
                if (timeOfStartDate > nowTime || timeOfEndDate < nowTime || this.isExcludeRecord(emap, userId)) continue;
                judgeRepeatPatternWithTimeList.add(emap);
                continue;
            }
            if (dateOfStartDate > nowDate || dateOfEndDate < nowDate || timeOfStartDate > nowTime || timeOfEndDate < nowTime) continue;
            judgeRepeatPatternWithTimeList.add(emap);
        }
        return judgeRepeatPatternWithTimeList;
    }

    public boolean isExcludeRecord(EipTScheduleMap map, int userId) {
        Integer parentId = map.getScheduleId();
        SelectQuery query = new SelectQuery(EipTSchedule.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"parentId", (Object)parentId);
        query.setQualifier(exp1);
        Expression exp2 = ExpressionFactory.matchExp((String)"ownerId", (Object)userId);
        query.andQualifier(exp2);
        Expression exp3 = ExpressionFactory.matchExp((String)"startDate", (Object)this.nowDate);
        query.andQualifier(exp3);
        List schedules = this.dataContext.performQuery((Query)query);
        return schedules != null && schedules.size() != 0;
    }

    public Map getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public List getMyGroupList() {
        return this.myGroupList;
    }

    public String getLoginUserId() {
        return this.login_user_id;
    }

    protected Object selectDetail(RunData rundata, Context context) throws ALPageNotFoundException {
        String UserIdVmStr = rundata.getParameters().getString("UserIdVm");
        AvzTWhereaboutsinformation info = WhereaboutsInformationUtils.getAvzTwhereaboutsinformationById(UserIdVmStr);
        return info;
    }

    protected Object getResultDataDetail(Object obj) {
        try {
            AvzTWhereaboutsinformation record = (AvzTWhereaboutsinformation)((Object)obj);
            WhereaboutsInformationContainer rd = new WhereaboutsInformationContainer();
            rd.initField();
            rd.setName(ALEipUtils.getUserFullName((int)record.getUserId()));
            rd.setReason(record.getNote());
            String reDate = WhereaboutsInformationUtils.translateDate(record.getReturnDate(), "M\u6708d\u65e5H\u6642m\u5206");
            rd.setReturnDate(reDate);
            return rd;
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return null;
        }
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("group", "turbineUserGroupRole.turbineGroup.groupName");
        return map;
    }
}

