/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.whereaboutsinformation;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.AvzTWhereaboutsinformation;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.whereaboutsinformation.util.WhereaboutsInformationUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class WhereaboutsInformationPermitFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WhereaboutsInformationPermitFormData.class.getName());
    private ALStringField permission;
    private ALStringField reason;
    private ALDateTimeField return_date;
    private DataContext dataContext;
    private int user_id;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.user_id = ALEipUtils.getUserId((RunData)rundata);
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
    }

    public void initField() {
    }

    protected void setValidator() {
    }

    protected boolean validate(ArrayList msgList) {
        return msgList.size() == 0;
    }

    public ALStringField getReason() {
        return this.reason;
    }

    public ALDateTimeField getReturnDate() {
        return this.return_date;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) {
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) {
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            SelectQuery query = new SelectQuery(AvzTWhereaboutsinformation.class);
            Expression exp = ExpressionFactory.matchExp((String)"userId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.setQualifier(exp);
            List list = this.dataContext.performQuery((Query)query);
            if (list.size() != 0) {
                AvzTWhereaboutsinformation info = WhereaboutsInformationUtils.getAvzTwhereaboutsinformation(rundata, context);
                if (info == null) {
                    return false;
                }
                info.setUpdateDate(Calendar.getInstance().getTime());
                String per = info.getPermission();
                if (per == null || per.equals("") || per.equals("A")) {
                    info.setPermission("P");
                } else {
                    info.setPermission("A");
                }
            } else {
                AvzTWhereaboutsinformation info = (AvzTWhereaboutsinformation)this.dataContext.createAndRegisterNewObject(AvzTWhereaboutsinformation.class);
                info.setUserId(ALEipUtils.getUserId((RunData)rundata));
                info.setCreateDate(Calendar.getInstance().getTime());
                info.setPermission("P");
                info.setStatus("P");
                info.setUpdateDate(Calendar.getInstance().getTime());
            }
            this.dataContext.commitChanges();
        }
        catch (Exception e) {
            this.dataContext.rollbackChanges();
            logger.error((Object)"Exception", (Throwable)e);
            return false;
        }
        return true;
    }

    public ALStringField getWhereaboutsInformationName() {
        return this.reason;
    }
}

